/*
 *  XScrabble - X version of the popular board game, for 1 to 4 players.
 *
 * This software comes with NO warranty whatsoever. I therefore take no
 * responsibility for any damages, losses or problems caused through use
 * or misuse of this program.
 *
 * I hereby grant permission for this program to be freely copied and
 * distributed by any means, provided no charge is made for it.
 *
 * Matthew Chapman, csuoq@csv.warwick.ac.uk
 *    Apr 1995.
 */

/* xglobals.h - external variables for X interface */

extern struct AppData {
    int version,players,timelim,t[4];
    String disp[4],name[4];
    Boolean load;
    String dictfile,permfile,scorefile;
} app_data;

/* xutils.c */
#include "xutils.h"

/* widgets.c */
void Quit();
void user_setup();
void set_board(Widget top,int dnum);
void SetupMenu(Widget top,int dnum);
void ProcessMenu(Widget w, XtPointer client_data, XtPointer call_data);
void BlankPopup();
void ChangePopup();
void bg_pixmap(Widget w);

/* popup.c */
void HiScoresPopup(int dnum);
void BestgoPopup(int dnum);
void UpdateBestgo();
void CreateHiScoresPopup(int dnum);
void CreateBestgoPopup(int dnum);
void LettValuesPopup(int dnum);
void CreateLettValuesPopup(int dnum);
void LettValuesPopdown(Widget w, XtPointer client_data, XtPointer call_data);
void AboutPopup(int dnum);
void CreateKeyPopup(int dnum);
void KeyPopup(int dnum);
void CreateKeyPopup(int dnum);

/* display.c */
void ShowTiles();
void ShowBar(int ply);
void TilesLeft();
void ShowScores();
void ShowBoard(Boolean leavecolours);
void MessageAll(char *mess);
void Message(int ply,char *mess1,char *mess2);
void MessageOne(int ply,char *mess);
void Wait(int delay);
void ProcessEvent();
void Click();
void UpdateComp(int perc);

/* user.c */
void Deselect(int ply);
void RemoveFromBoard();
void Select_sq(Widget w, XtPointer client_data, XtPointer call_data);
void GotoNextPlayer();
void ComputerGo();
void FinishGo(Widget w, XtPointer client_data, XtPointer call_data);
void BlankPopdown(Widget w, XtPointer client_data, XtPointer call_data);
void ChangePopdown(Widget w, XtPointer client_data, XtPointer call_data);
void PassGo();
void GameOver(int ply);
void RevertToBar(Widget w, XtPointer client_data, XtPointer call_data);
void Juggle(Widget w, XtPointer client_data, XtPointer call_data);

/* mess.c */
void CreateMess(int dnum);
void MessPopup(int dnum);
extern Widget messtop[];

extern XtAppContext app_context;
extern Widget topLevel,sq[MAXPLAYERS][BOARDSIZE][BOARDSIZE];
extern Widget br[][LONGBAR];
extern Widget message[];
extern Widget all,title,lvtop[],lvdismiss[];
extern Widget barw[],tilesleft[];
extern Widget timeleft[],scoretitle,scorebox[];

extern Widget menuButton[],menu[],menu_item[MAXPLAYERS][MENU_ITEMS];

/* buttons */
extern Widget finish[],change[];
extern Widget pass[],evaluate[];

extern Widget title;
extern Widget blankshell,hi_scoretop[],blankf,blanktitle,a2z[];
extern Widget changeshell,changef,changetitle,changeconfirm,changecancel;
extern Widget changeletts[BARLEN],topl[];
extern Widget hi_score_ent[MAXPLAYERS][MAXPLAYERS],hi_dismiss[];
extern Widget bestgotop[],bestgodismiss[],bestgomain[];;
extern Widget keytop[],keydismiss[];
extern Widget abouttop[],aboutdismiss[];
extern Widget compw[];

/* extra buttons */
extern Widget lastgo[],revert[],juggle[];

extern Display *dpy[];

extern Pixmap bgxpm,mark[];
extern Boolean menu_status[MAXPLAYERS][MENU_ITEMS];

extern char *colours[];
extern char bar[MAXPLAYERS][LONGBAR];
extern Boolean is_perm[BOARDSIZE][BOARDSIZE];
extern Boolean waiting,waiting_for_blank,waiting_for_change,finished_go;
extern char blank_letter;

extern char cboard[BOARDSIZE][BOARDSIZE];

/* to check for everyone passing */
extern int num_passed;

extern int type[];

/* for the timer */
extern int comp,time_limit;
