/* keysyms.c: keysym to Spectrum key mappings for Win32
   Copyright (c) 2003 Marek Januszewski

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 49 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   Author contact information:

   E-mail: pak21-fuse@srcf.ucam.org
   Postal address: 15 Crescent Road, Wokingham, Berks, RG40 2DB, England

*/

/* This file is autogenerated from keysyms.dat by keysyms.pl.
   Do not edit unless you know what you're doing! */

#include <config.h>

#ifdef UI_WIN32			/* Use this iff we're using UI_WIN32 */

#include "keyboard.h"
#include "ui/ui.h"

#include <windows.h>

/* http://msdn.microsoft.com/library/default.asp?url=/library/en-us/w98ddk/hh/w98ddk/keycnt_4fqw.asp */

const keysyms_key_info keysyms_data[] = {

  { VK_ESCAPE,       KEYBOARD_1,        KEYBOARD_Caps   },
  { '1',             KEYBOARD_1,        KEYBOARD_NONE   },
  { '2',             KEYBOARD_2,        KEYBOARD_NONE   },
  { '3',             KEYBOARD_3,        KEYBOARD_NONE   },
  { '4',             KEYBOARD_4,        KEYBOARD_NONE   },
  { '5',             KEYBOARD_5,        KEYBOARD_NONE   },
  { '6',             KEYBOARD_6,        KEYBOARD_NONE   },
  { '7',             KEYBOARD_7,        KEYBOARD_NONE   },
  { '8',             KEYBOARD_8,        KEYBOARD_NONE   },
  { '9',             KEYBOARD_9,        KEYBOARD_NONE   },
  { '0',             KEYBOARD_0,        KEYBOARD_NONE   },
  /* minus */ 
  { 189,             KEYBOARD_j,        KEYBOARD_Symbol },
  /* equals */ 
  { 187,             KEYBOARD_l,        KEYBOARD_Symbol },
  { VK_BACK,         KEYBOARD_0,        KEYBOARD_Caps   },
  { 'Q',             KEYBOARD_q,        KEYBOARD_NONE   },
  { 'W',             KEYBOARD_w,        KEYBOARD_NONE   },
  { 'E',             KEYBOARD_e,        KEYBOARD_NONE   },
  { 'R',             KEYBOARD_r,        KEYBOARD_NONE   },
  { 'T',             KEYBOARD_t,        KEYBOARD_NONE   },
  { 'Y',             KEYBOARD_y,        KEYBOARD_NONE   },
  { 'U',             KEYBOARD_u,        KEYBOARD_NONE   },
  { 'I',             KEYBOARD_i,        KEYBOARD_NONE   },
  { 'O',             KEYBOARD_o,        KEYBOARD_NONE   },
  { 'P',             KEYBOARD_p,        KEYBOARD_NONE   },
  { VK_CAPITAL,      KEYBOARD_2,        KEYBOARD_Caps   },
  { 'A',             KEYBOARD_a,        KEYBOARD_NONE   },
  { 'S',             KEYBOARD_s,        KEYBOARD_NONE   },
  { 'D',             KEYBOARD_d,        KEYBOARD_NONE   },
  { 'F',             KEYBOARD_f,        KEYBOARD_NONE   },
  { 'G',             KEYBOARD_g,        KEYBOARD_NONE   },
  { 'H',             KEYBOARD_h,        KEYBOARD_NONE   },
  { 'J',             KEYBOARD_j,        KEYBOARD_NONE   },
  { 'K',             KEYBOARD_k,        KEYBOARD_NONE   },
  { 'L',             KEYBOARD_l,        KEYBOARD_NONE   },
  /* semicolon */ 
  { 186,             KEYBOARD_o,        KEYBOARD_Symbol },
  /* apostrophe */ 
  { 222,             KEYBOARD_7,        KEYBOARD_Symbol },
//  { GDK_numbersign,  KEYBOARD_3,        KEYBOARD_Symbol },
  { VK_RETURN ,      KEYBOARD_Enter,    KEYBOARD_NONE   },
  /* left shift */
  { VK_SHIFT,        KEYBOARD_NONE,     KEYBOARD_Caps   },
  { 'Z',             KEYBOARD_z,        KEYBOARD_NONE   },
  { 'X',             KEYBOARD_x,        KEYBOARD_NONE   },
  { 'C',             KEYBOARD_c,        KEYBOARD_NONE   },
  { 'V',             KEYBOARD_v,        KEYBOARD_NONE   },
  { 'B',             KEYBOARD_b,        KEYBOARD_NONE   },
  { 'N',             KEYBOARD_n,        KEYBOARD_NONE   },
  { 'M',             KEYBOARD_m,        KEYBOARD_NONE   },
  /* comma */
  { 188,             KEYBOARD_n,        KEYBOARD_Symbol },
  /* period */
  { 190,             KEYBOARD_m,        KEYBOARD_Symbol },
  /* slash */ 
  { 191,             KEYBOARD_v,        KEYBOARD_Symbol },
  /* right shift */
  { VK_SHIFT,        KEYBOARD_NONE,     KEYBOARD_Caps   },
  /* left control */
  { VK_CONTROL,      KEYBOARD_NONE,     KEYBOARD_Symbol },
//  { GDK_Alt_L,       KEYBOARD_NONE,     KEYBOARD_Symbol },
//  { GDK_Meta_L,      KEYBOARD_NONE,     KEYBOARD_Symbol },
//  { GDK_Super_L,     KEYBOARD_NONE,     KEYBOARD_Symbol },
//  { GDK_Hyper_L,     KEYBOARD_NONE,     KEYBOARD_Symbol },
  { VK_SPACE,        KEYBOARD_space,    KEYBOARD_NONE   },
//  { GDK_Hyper_R,     KEYBOARD_NONE,     KEYBOARD_Symbol },
//  { GDK_Super_R,     KEYBOARD_NONE,     KEYBOARD_Symbol },
//  { GDK_Meta_R,      KEYBOARD_NONE,     KEYBOARD_Symbol },
//  { GDK_Alt_R,       KEYBOARD_NONE,     KEYBOARD_Symbol },
  /* right control */
  { VK_CONTROL,      KEYBOARD_NONE,     KEYBOARD_Symbol },
//  { GDK_Mode_switch, KEYBOARD_NONE,     KEYBOARD_Symbol },
  { VK_LEFT,         KEYBOARD_5,        KEYBOARD_Caps   },
  { VK_DOWN,         KEYBOARD_6,        KEYBOARD_Caps   },
  { VK_UP,           KEYBOARD_7,        KEYBOARD_Caps   },
  { VK_RIGHT,        KEYBOARD_8,        KEYBOARD_Caps   },
  { VK_TAB,          KEYBOARD_0,        KEYBOARD_Caps   },
  { VK_PRIOR,        KEYBOARD_PageUp,   KEYBOARD_NONE   },
  { VK_NEXT,         KEYBOARD_PageDown, KEYBOARD_NONE   },
  { VK_HOME,         KEYBOARD_Home,     KEYBOARD_NONE   },
  { VK_END,          KEYBOARD_End,      KEYBOARD_NONE   },

  { 0, 0, 0 }                   /* End marker: DO NOT MOVE! */

};

#endif			/* #ifdef UI_WIN32 */
