%  Copyright (C) 2002-2003 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\section{darcs revert}
\begin{code}
module Revert ( revert ) where
import DarcsCommands
import DarcsArguments
import Directory
import IO
import System
import Monad
import Repository
import Patch
import PatchInfo
import SlurpDirectory
import DarcsArguments
import Record ( select_changes )
import Lock ( withLock )
\end{code}
\begin{code}
revert_description =
 "Revert to recorded version."
\end{code}

\options{revert}

\haskell{revert_help} Please be cautious with revert, as there is no way to
unrevert.  Although I could store an unrevert patch somewhere, if there is
demand for such a feature...

\begin{code}
revert_help =
 "Revert is used to undo changes make to the local tree which have
not yet been recorded.  You will be prompted for which changes you
wish to undo.
"
\end{code}
\begin{code}
revert = DarcsCommand {command_name = "revert",
                       command_help = revert_help,
                       command_description = revert_description,
                       command_extra_args = 0,
                       command_command = revert_cmd,
                       command_prereq = am_in_repo,
                       command_get_arg_possibilities = return [],
                       command_argdefaults = nodefaults,
                       command_darcsoptions = [verbose, ignoretimes,
                                               all_patches]}
\end{code}
\begin{code}
revert_cmd opts args = withLock "./_darcs/lock" $ do
  changes <- if All `elem` opts
             then get_unrecorded (AnyOrder:opts)
             else get_unrecorded opts
  working_dir <- slurp "."
  case changes of
    Nothing -> putStr "There are no changes to revert!\n"
    Just pboring -> do
      p <- join_patches `liftM`
           select_changes "revert" opts (flatten $ invert pboring)
      putStr "Do you really want to do this? "
      hFlush stdout
      yorn <- getLine
      case yorn of
        ('y':_) -> return ()
        otherwise -> exitWith $ ExitFailure 1
      putStr "If you're serious, type `I am deadly serious.'\n"
      serious <- getLine
      when (serious /= "I am deadly serious.") $ exitWith $ ExitFailure 1
      case apply_to_slurpy p working_dir of
        Nothing -> do putStr "Error.  Unable to apply inverse patch!\n"
                      writeFile "_darcs/patches/pending" ""
                      exitWith $ ExitFailure 1
        Just working -> do
              writeFile "_darcs/patches/pending" ""
              slurp_write_dirty working
              putStr $ "Finished reverting.\n"
is_named :: [FilePath] -> Patch -> Bool
is_named fs p = or $ map (is_similar p . addfile) fs
\end{code}
