%  Copyright (C) 2003 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\section{Resolution of conflicts}
\begin{code}
module Resolution ( standard_resolution, hand_resolution, no_resolution,
                  ) where
import Patch
\end{code}

\begin{code}
standard_resolution :: Patch -> Patch
hand_resolution :: Patch -> Patch
\end{code}

\begin{code}
standard_resolution p =
    join_patches [p,merge_list $ map head $ resolve_conflicts p]
hand_resolution = standard_resolution
no_resolution p = p
\end{code}

\begin{code}
merge_list :: [Patch] -> Patch
merge_list ps = doml (join_patches []) ps
doml mp (p:ps) = case merge (mp,p) of
                 Just (mp',_) -> doml (join_patches $ p : (flatten mp')) ps
doml mp [] = mp
\end{code}
