%  Copyright (C) 2003 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

\begin{code}
module PrintPatch ( printPatch,
                  ) where

import IO
import Char ( chr )

import Patch ( Patch )
\end{code}


\begin{code}
printPatch :: Patch -> IO ()
printPatch p = putStr $ escape_escapes $ show p

escape_escapes "" = ""
escape_escapes ('\x1B':cs) = '^':'[': escape_escapes cs
escape_escapes ('h':'u':'n':'k':' ':cs) =
    "\x1B[01;34mhunk\x1B[00m " ++ escape_escapes cs
escape_escapes (c:cs) = c : escape_escapes cs
\end{code}
