%  Copyright (C) 2003 David Roundy
%
%  This program is free software; you can redistribute it and/or modify
%  it under the terms of the GNU General Public License as published by
%  the Free Software Foundation; either version 2, or (at your option)
%  any later version.
%
%  This program is distributed in the hope that it will be useful,
%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%  GNU General Public License for more details.
%
%  You should have received a copy of the GNU General Public License
%  along with this program; if not, write to the Free Software Foundation,
%  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
\section{Dependencies}
\begin{code}
module Depends ( get_common_and_uncommon, get_tags_right,
                 optimize_patchset,
               ) where
import List ( elem, delete, intersect )
import Monad ( liftM )
import Maybe ( fromJust )

import Patch
import PatchInfo
import RepoTypes ( PatchSet, PatchSequence )
\end{code}

\begin{code}
get_tags_right :: PatchSet -> [PatchInfo]
get_common_and_uncommon :: (PatchSet,PatchSet) ->
                           ([PatchInfo],PatchSet,PatchSet)
\end{code}

\begin{code}
safehead [] = []
safehead (a:_) = a
get_common_and_uncommon (ps1,ps2)
    | null ps1 || null ps2 = ([],[concat ps1],[concat ps2])
get_common_and_uncommon ([(pi1,_)]:_,[(pi2,_)]:_)
    | pi1 == pi2 = ([pi1],[[]],[[]])
get_common_and_uncommon (ps1:ps1b:ps1s,ps2:ps2b:ps2s) =
  if (fst $ head $ reverse ps1) == (fst $ head $ reverse ps2)
  then case (map fst ps1) `intersect` (map fst ps2) of
       common -> (map fst $ safehead $ optimize_patchset $
                  [filter ((`elem` common).fst) ps1],
                  [get_extra [] common ps1],
                  [get_extra [] common ps2])
  else if length ps1 > length ps2
       then get_common_and_uncommon (ps1:ps1b:ps1s, (ps2++ps2b):ps2s)
       else get_common_and_uncommon ((ps1++ps1b):ps1s, ps2:ps2b:ps2s)
get_common_and_uncommon ([ps1],[ps2]) =
    case (map fst ps1) `intersect` (map fst ps2) of
    common -> (map fst $ safehead $ optimize_patchset $
               [filter ((`elem` common).fst) ps1],
               [get_extra [] common ps1],
               [get_extra [] common ps2])
get_common_and_uncommon ([ps1],ps2s) =
    get_common_and_uncommon ([ps1],[concat ps2s])
get_common_and_uncommon (ps1s,[ps2]) =
    get_common_and_uncommon ([concat ps1s],[ps2])

get_extra skipped concat [] = []
get_extra skipped common ((pi, mp):pps) =
    if pi `elem` common && is_tag pi
    then case liftM getdeps mp of
         Just ds -> get_extra (fromJust mp:skipped) (ds++delete pi common) pps
         Nothing -> get_extra (fromJust mp:skipped) (delete pi common) pps
    else if pi `elem` common
         then get_extra (fromJust mp:skipped) (delete pi common) pps
         else case commute (join_patches skipped, fromJust mp) of
              Just (p', skipped_patch') ->
                  (pi,Just p') : get_extra (flatten skipped_patch') common pps
\end{code}

\begin{code}
is_tag pi = take 3 (just_name pi) == "TAG"

get_tags_right [] = []
get_tags_right (ps:_) = get_tags_r ps

get_tags_r [] = []
get_tags_r ((pi,mp):pps)
    | is_tag pi = case liftM getdeps mp of
                  Just ds -> pi : get_tags_r (drop_tags_r ds pps)
                  Nothing -> pi : map fst pps
    | otherwise = pi : get_tags_r pps
drop_tags_r :: [PatchInfo] -> PatchSequence -> PatchSequence
drop_tags_r [] pps = pps
drop_tags_r _ [] = []
drop_tags_r ds ((pi,mp):pps)
    | pi `elem` ds && is_tag pi =
        case liftM getdeps mp of
        Just ds' -> drop_tags_r (ds'++delete pi ds) pps
        Nothing -> drop_tags_r (delete pi ds) pps
    | pi `elem` ds = drop_tags_r (delete pi ds) pps
    | otherwise = (pi,mp) : drop_tags_r ds pps
\end{code}

\begin{code}
optimize_patchset :: PatchSet -> PatchSet
optimize_patchset [] = []
optimize_patchset (ps:pss) = opsp ps ++ pss
opsp :: [(PatchInfo,Maybe Patch)] -> PatchSet
opsp [] = []
opsp ((pi,mp):pps) =
  if is_tag pi
  then if get_tags_right [(pi,mp):pps] == [pi]
       then[[(pi,mp)]] ++ opsp pps
       else boring
  else boring
  where boring = case opsp pps of
                 [] -> [[(pi,mp)]]
                 (pps':rest) -> ((pi,mp):pps') : rest
\end{code}
