/* 
 *  Copyright (C) 1999 Bernd Gehrmann
 *                     bernd@physik.hu-berlin.de
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the "Artistic License" which comes with this Kit. 
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Artistic License for more details.
 *
 * You should have received a copy of the Artistic License with 
 * this Kit, in the file named "Artistic".  If not, I'll be glad
 * to provide one.
 */


#ifndef DIFFVIEW_H_20010626
#define DIFFVIEW_H_20010626

#include "config.h"
#include "ac_system_defs.h"

#include <qtableview.h>
#include <qlist.h>


class DiffViewItem;
class DiffViewItemList;

class DiffView : public QTableView
{
    Q_OBJECT
    
public:
    enum DiffType { Change, Insert, Delete, Neutral, Unchanged };

    DiffView( bool withlinenos, bool withmarker,
	      QWidget *parent=0, const char *name=0 );
    ~DiffView( );

    void setPartner(DiffView *other);

    void addLine(QString line, DiffType type, int no=-1);
    QString stringAtLine(int lineno);

    int count();
    QString stringAtOffset(unsigned offset);
    void removeAtOffset(int offset);
    void insertAtOffset(QString line, DiffType type, int offset);

    void setCenterLine(int lineno);
    void setCenterOffset(int offset);
    void setInverted(int lineno, bool inverted);
    virtual int cellWidth(int col);
    virtual QSize sizeHint() const;
    virtual void paintCell(QPainter *p, int row, int col);

protected slots:
    void positionChanged(int val);
    void findPrevDiff ();
    void findNextDiff ();
  
private:

    void recalcTableSize( DiffViewItem * It = 0 );

    int findLine(int lineno);
    DiffViewItemList * items;
    bool linenos;
    bool marker;
    int textwidth;
    DiffView *partner;
    int TableSize;
};

#endif  //DIFFVIEW_H_20010626

