/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/SettingsDialogImpl.h,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/10/23 23:27:29 $
 *!!	$Revision: 1.3 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 The LinCVS development team.
 *!!	    Tilo Riemer <riemer@lincvs.org>
 *!!	    Falk Brettschneider <gigafalk@yahoo.com>
 *!!	    Wim Delvaux <wim.delvaux@chello.be>
 *!!	    Jose Hernandez <joseh@tesco.net>
 *!!        Helmut Koll <HelmutKoll@web.de>
 *!!	    Sven Trogisch <trogisch@iapp.de>
 *!!
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#ifndef SETTINGSDIALOGIMPL_H
#define SETTINGSDIALOGIMPL_H
#include "SettingsDialog.h"

class SettingsDialogImpl : public SettingsDialog
{ 
	Q_OBJECT

	enum APPSTYLE
	{
		APPSTYLE_CDE,
		APPSTYLE_JFC,
		APPSTYLE_METAL,
		APPSTYLE_MOTIF,
		APPSTYLE_MOTIFPLUS,
		APPSTYLE_NORWEGIANWOOD,
		APPSTYLE_PLATINUM,
		APPSTYLE_SGI,
		APPSTYLE_STEP,
		APPSTYLE_WINDOWS
	};

public:
	SettingsDialogImpl(QWidget* parent = 0, const char* name = 0,
			   bool modal = FALSE, WFlags fl = 0);
	~SettingsDialogImpl();

	static void setStyle (APPSTYLE style);
	static void setStyle (QString style);

protected slots:
	void accept();
	void apply();
	void setAppFont();

private:
	QFont m_AppFont;

	static APPSTYLE stringToNumericStyle (QString style);
};


#endif // SETTINGSDIALOGIMPL_H
