/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/CmdThread.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/07/18 23:10:26 $
 *!!	$Revision: 1.1 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 The LinCVS development team.
 *!!    Tilo Riemer <riemer@lincvs.org>
 *!!    Falk Brettschneider <gigafalk@yahoo.com>
 *!!    Wim Delvaux <wim.delvaux@chello.be>
 *!!    Jose Hernandez <joseh@tesco.net>
 *!!    Helmut Koll <HelmutKoll@web.de>
 *!!    Sven Trogisch <trogisch@iapp.de>
 *!!
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#include "config.h"
#include "ac_system_defs.h"

#include <stdio.h>
#include "globals.h"
#include "CmdThread.h"



CmdThread::CmdThread (QString cmdstr) : m_command(cmdstr)
{
}


CmdThread::~CmdThread ()
{
}


void CmdThread::run ()
{
	if ((m_pCvs = popen (m_command, "r")) == NULL)
	{
		// Need proper error handling here
		perror("popen");
		return;
	}

	char buffer [512];

	while (fgets (buffer, sizeof buffer, m_pCvs))
	{
		buffer [strlen(buffer) - 1] = '\0';

		lockOutputQueue ();
		m_outputQueue.append(buffer);
		unlockOutputQueue ();

		if (globalStopAction)
		{
			pclose (m_pCvs);
			return;
		}
	}

	pclose (m_pCvs);
}


QString& CmdThread::getCommand ()
{
	return m_command;
}


void CmdThread::lockOutputQueue ()
{
	m_outputQueueMutex.lock();
}


void CmdThread::unlockOutputQueue ()
{
	m_outputQueueMutex.unlock();
}
