#ifndef COMMON_PTRARRAY_H
#define COMMON_PTRARRAY_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

struct ObVec {
  Serializable ser;

  uint32_t      size;
  uint32_t      maxSize;
  uint32_t      height;
  const void  *elements;
};
typedef struct ObVec ObVec;

/* StrVec is the same structure as ObVec. The reason we duplicate it
 * is that C does not use structural type equivalence. By making this
 * a different structure type we can have different methods for it
 * that are checked by the type checker, and still cast it to the
 * ObVec type to reuse the underlying ObVec methods (relying on
 * structural equivalence). */
struct StrVec {
  Serializable ser;

  uint32_t      size;
  uint32_t      maxSize;
  uint32_t      height;
  const char  *elements;
};
typedef struct StrVec StrVec;
typedef struct StrVec TnVec;

ObVec *obvec_create(void);
void   obvec_append(ObVec *vec, const void *vp);
void   obvec_sort(ObVec *vec);

/* anyone using these? */
ObVec *obvec_shallow_copy(ObVec *vec);

StrVec * strvec_create(void);
void     strvec_append(StrVec *vec, const char *s);
char *   strvec_flatten(StrVec *vec);
void     strvec_sort(StrVec *vec);
void     strvec_bremove(StrVec *vec, const char *s); /* use when sorted */
int      strvec_bsearch(StrVec *vec, const char *s); /* use when sorted */

TnVec   *tnvec_create(void);
void    tnvec_append(TnVec *vec, const char *s);
void    tnvec_sort(TnVec *vec);
void    tnvec_bremove(TnVec *vec, const char *s); /* use when sorted */
int     tnvec_bsearch(TnVec *vec, const char *s); /* use when sorted */

/* These leverage the underlying representation pun... */
void vec_remove(void *vec, uint32_t ndx);
uint32_t vec_size(const void*);

int vec_bsearch(const void* vec, const void* elem,
                int (*cmp)(const void *, const void *));

void vec_sort_using(void *vec,
                    int (*cmp)(const void *, const void *));

const void* vvec_fetch(const ObVec*, uint32_t);
#define vec_fetch(vec,ndx,ty) ((ty) vvec_fetch((const ObVec *)vec, ndx))

#endif /* COMMON_PTRARRAY_H */

