#ifndef CLIENT_OPENCMCLIENT_H
#define CLIENT_OPENCMCLIENT_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

typedef struct PendingChange PendingChange;
typedef struct WsEntity WsEntity;
typedef struct FilterSet FilterSet;
typedef struct Filter Filter;

#include "nmlist.h"
#include "WsEntity.h"
#include "PendingChange.h"
#include "FilterSet.h"
#include "WorkSpace.h"
#include "Resolver.h"

#include "command.h"

#ifndef __unix__
#define BROKEN_FS_ENTITIES
#endif

/* Used to identify a line in a description that can
 * be stripped out by calling strip_comments() */
#define COMMENT_LEADER "OPENCM: "

/* Used as a flag when calling ws_mergeFromX();  determines
 * whether merge is executed from 'update' or 'merge' command: */
#define FROM_UPDATE TRUE
#define FROM_MERGE  FALSE

/* Used by client to resolve namespace lookups */
typedef struct rsolv_struct {
  URI *uri;
  char *residual;
} rsolv_struct;

Serializable *
client_GetMutableContent(Repository *r, const char *trueName);

Mutable *
client_GetMutable(Repository *r, const char *trueName);

void ShowHelp(const char *basename);

#endif /* CLIENT_OPENCMCLIENT_H */
