#ifndef CLIENT_RESOLVER_H
#define CLIENT_RESOLVER_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
  Options for the resolver

  NO_RESULT: Throw an exception if any matches are found (or on error)
  SINGLE_RESULT: Throw ExNoObject if we get 0 matches, or >1 match, or an error
  MANY_RESULTS: Throw ExNoObject if we get an error or no matches.
                Returns an ObVec of size >= 1

  If you pass 0 as the flag, you get the behavior that any (non-error) resolve
  will return, with a vector of zero or more objects. This is the same as the
  previous behaviour (when the flags value was ignored)
*/
#define RESOLVER_OPT_NO_RESULT     0x01
#define RESOLVER_OPT_SINGLE_RESULT 0x02
#define RESOLVER_OPT_MANY_RESULTS  0x04

typedef struct Resolution {
  const char   *fullPath;	/* full path as presented */
  const char   *fp_frag;	/* last part of full path (as a convenience) */
  Mutable      *m;		/* rightmost mutable in input pattern */
  Serializable *s;		/* corresponding content */
  const char   *rest;		/* residual path */
  Serializable *tail;		/* Serializable for tail resolved item */
} Resolution;

/* NOTE: as the member (resolutions) are not serializables, do NOT
   attempt to serialize this ObVec! */
ObVec *resolve(Repository *r, const char *arg, unsigned flags);

#endif /* CLIENT_RESOLVER_H */
