/***************************************************************************
 *   Copyright (C) 2006 by Vladimir Kuznetsov                              *
 *   vovanec@gmail.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QString>
#include <QStringList>

QString buttonFromInteger(Qt::MouseButton btn)
{
        switch(btn)
        {
            case Qt::NoButton:
                return "Qt::NoButton";
            case Qt::LeftButton:
                return "Qt::LeftButton";
            case Qt::RightButton:
                return "Qt::RightButton";
            case Qt::MidButton:
                return "Qt::MidButton";
            case Qt::XButton1:
                return "Qt::XButton1";
            case Qt::XButton2:
                return "Qt::XButton2";
            default:
                return QString::number(btn);
        }
}
QString dropActionFromInteger(Qt::DropAction a)
{
        switch(a)
        {
            case Qt::CopyAction:
                return "Qt::CopyAction";
            case Qt::MoveAction:
                return "Qt::MoveAction";
            case Qt::LinkAction:
                return "Qt::LinkAction";
            case Qt::TargetMoveAction:
                return "Qt::TargetMoveAction";
            case Qt::IgnoreAction:
                return "Qt::IgnoreAction";
            default:
                return QString::number(a);
        }
}

QString reasonFromInteger(Qt::FocusReason r)
{
    switch(r)
    {
        case Qt::MouseFocusReason:
            return "Qt::MouseFocusReason";
        case Qt::TabFocusReason:
            return "Qt::TabFocusReason";
        case Qt::BacktabFocusReason:
            return "Qt::BacktabFocusReason";
        case Qt::ActiveWindowFocusReason:
            return "Qt::ActiveWindowFocusReason";
        case Qt::PopupFocusReason:
            return "Qt::PopupFocusReason";
        case Qt::ShortcutFocusReason:
            return "Qt::ShortcutFocusReason";
        case Qt::MenuBarFocusReason:
            return "Qt::MenuBarFocusReason";
        case Qt::OtherFocusReason:
            return "Qt::OtherFocusReason";
        default:
            return QString::number(r);
    }
}

QStringList buttonsFromInteger(Qt::MouseButtons btns)
{
    QStringList buttons;
    if(btns & Qt::NoButton)
         buttons << "Qt::NoButton";
    if( btns & Qt::LeftButton)
        buttons << "Qt::LeftButton";
    if( btns & Qt::RightButton)
        buttons << "Qt::RightButton";
    if( btns & Qt::MidButton)
        buttons << "Qt::MidButton";
    if( btns & Qt::XButton1)
        buttons << "Qt::XButton1";
    if( btns & Qt::XButton2)
        buttons << "Qt::XButton2";
    return buttons;
}

QStringList modifiersFromInteger(Qt::KeyboardModifiers m)
{
    QStringList modifiers;
    if( m & Qt::NoModifier)
         modifiers << "Qt::NoModifier";
    if( m & Qt::ShiftModifier)
        modifiers << "Qt::ShiftModifier";
    if( m & Qt::ControlModifier)
        modifiers << "Qt::ControlModifier";
    if( m & Qt::AltModifier)
        modifiers << "Qt::AltModifier";
    if( m & Qt::MetaModifier)
        modifiers << "Qt::MetaModifier";
    if( m & Qt::KeypadModifier)
        modifiers << "Qt::KeypadModifier";
    if( m & Qt::GroupSwitchModifier)
        modifiers << "Qt::GroupSwitchModifier";
    return modifiers;
}

