#!/usr/bin/env perl

# Some tests for 'darcs record '

use Test::More qw/no_plan/;
use lib ('lib/perl');
use Test::Darcs;
use strict;
use Shell::Command;
use Cwd;

rm_rf  'temp1';
mkpath 'temp1';
chdir  'temp1';
darcs  'init';

###

{
    my $test_name = 'RT#231 - special message is given for nonexistent directories';
    like( darcs(qw/record -A x -am foo not_there.txt/),qr/non ?existent/i, $test_name) ;
}

{
    my $test_name = 'RT#231 - a nonexistent file before an existing file is handled correctly';
    touch 'b.t';
    like( darcs(qw/record -A x -am foo a.t b.t/),
          qr/Non ?existent files or directories: "a.t"/i, $test_name) ;
}



TODO: {
    local $TODO =  "waiting on code for record to work with absolute paths";
    my $test_name = 'record works with absolute paths';

    touch 'date.t';
    darcs qw/add date.t/;

    like( darcs(qw!record -A x -a -m foo!, cwd()."/date.t"), qr/finished recording/i, $test_name);
}

BASIC_RECORD: {
    my $test_name = 'basic record';
    `date >> date.t`;
    like( darcs(qw/record -A x -a -m basic_record date.t/), qr/finished recording/i, $test_name);
}

LOGFILE: {
    my $test_name = 'testing --logfile';
    `date >> date.t`;
    `echo 'second record'>>log.txt`;
    like( darcs(qw/record -A x -a -m 'second record' --logfile=log.txt  date.t/), qr/finished recording/i, $test_name);

}

###

chdir '../';
rm_rf 'temp1';
ok((!-d 'temp1'), 'temp1 directory was deleted');




