// -- Thatcher Ulrich <tu@tulrich.com> 2003

// This source code has been donated to the Public Domain.  Do
// whatever you want with it.

// SWF buttons.  Mouse-sensitive update/display, actions, etc.


#ifndef GNASH_BUTTON_CHARACTER_DEF_H
#define GNASH_BUTTON_CHARACTER_DEF_H


//#include "impl.h" // should get rid of this
#include "character_def.h"
#include "sound.h"

// Forward declarations
namespace gnash {
	class sprite_instance;
}

namespace gnash {

class button_record
{
public:
	bool	m_hit_test;
	bool	m_down;
	bool	m_over;
	bool	m_up;
	int	m_character_id;
	character_def*	m_character_def;
	int	m_button_layer;
	matrix	m_button_matrix;
	cxform	m_button_cxform;

	bool	read(stream* in, int tag_type, movie_definition* m);
};
	
class button_action
{
public:
	enum condition
	{
		IDLE_TO_OVER_UP = 1 << 0,
		OVER_UP_TO_IDLE = 1 << 1,
		OVER_UP_TO_OVER_DOWN = 1 << 2,
		OVER_DOWN_TO_OVER_UP = 1 << 3,
		OVER_DOWN_TO_OUT_DOWN = 1 << 4,
		OUT_DOWN_TO_OVER_DOWN = 1 << 5,
		OUT_DOWN_TO_IDLE = 1 << 6,
		IDLE_TO_OVER_DOWN = 1 << 7,
		OVER_DOWN_TO_IDLE = 1 << 8
	};
	int	m_conditions;
	std::vector<action_buffer*>	m_actions;

	~button_action();
	void	read(stream* in, int tag_type);
};


class button_character_definition : public character_def
{
public:
	struct sound_envelope
	{
		uint32_t m_mark44;
		uint16_t m_level0;
		uint16_t m_level1;
	};

	struct sound_info
	{
		void read(stream* in);

		bool m_no_multiple;
		bool m_stop_playback;
		bool m_has_envelope;
		bool m_has_loops;
		bool m_has_out_point;
		bool m_has_in_point;
		uint32_t m_in_point;
		uint32_t m_out_point;
		uint16_t m_loop_count;
		std::vector<sound_envelope> m_envelopes;
	};

	struct button_sound_info
	{
		uint16_t m_sound_id;
		sound_sample_impl*	m_sam;
		sound_info m_sound_style;
	};

	struct button_sound_def
	{
		void	read(stream* in, movie_definition* m);
		button_sound_info m_button_sounds[4];
	};


	bool m_menu;
	std::vector<button_record>	m_button_records;
	std::vector<button_action>	m_button_actions;
	button_sound_def*	m_sound;

	button_character_definition();
	virtual ~button_character_definition();

	/// Create a mutable instance of our definition.
	character* create_character_instance(character* parent, int id);

	void	read(stream* in, int tag_type, movie_definition* m);
};

}	// end namespace gnash


#endif // GNASH_BUTTON_CHARACTER_DEF_H


// Local Variables:
// mode: C++
// c-basic-offset: 8 
// tab-width: 8
// indent-tabs-mode: t
// End:
