// 
//   Copyright (C) 2005, 2006 Free Software Foundation, Inc.
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

// Linking Gnash statically or dynamically with other modules is making a
// combined work based on Gnash. Thus, the terms and conditions of the GNU
// General Public License cover the whole combination.
//
// As a special exception, the copyright holders of Gnash give you
// permission to combine Gnash with free software programs or libraries
// that are released under the GNU LGPL and with code included in any
// release of Talkback distributed by the Mozilla Foundation. You may
// copy and distribute such a system following the terms of the GNU GPL
// for all but the LGPL-covered parts and Talkback, and following the
// LGPL for the LGPL-covered parts.
//
// Note that people who make modified versions of Gnash are not obligated
// to grant this special exception for their modified versions; it is their
// choice whether to do so. The GNU General Public License gives permission
// to release a modified version without this exception; this exception
// also makes it possible to release a modified version which carries
// forward this exception.
// 
//
#ifndef __RC_H__
#define __RC_H__

// This is generated by autoconf
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "tu_config.h"

#include <string>
#include <vector>

namespace gnash {
  
class DSOLOCAL RcInitFile 
{
public:
    RcInitFile();
    ~RcInitFile();

    DSOEXPORT bool loadFiles();
    bool parseFile(std::string filespec);
    bool updateFile(std::string filespec);
    
    bool useSplashScreen() { return _splash_screen; };
    void useSplashScreen(bool value);

    bool useActionDump() { return _actiondump; };
    void useActionDump(bool value);

    bool useParserDump() { return _parserdump; };
    void useParserDump(bool value);

    bool useWriteLog() { return _writelog; };
    void useWriteLog(bool value);

    int getTimerDelay() { return _delay; };
    void setTimerDelay(int x) { _delay = x; };
    
    int verbosityLevel() { return _verbosity; };
    void verbosityLevel(int value) { _verbosity = value; };
    
    std::string getDebugLog() { return _log; };
    std::string getDocumentRoot() { return _wwwroot; };
    
    bool useDebugger() { return _debugger; };
    void useDebugger(bool value) { _debugger = value; }

    bool useLocalDomain() { return _localdomain_only; };
    void useLocalDomain(bool value);
    
    bool useLocalHost() { return _localhost_only; };
    void useLocalHost(bool value);

    bool extractSetting(bool *var, const char *pattern, std::string &variable,
                        std::string &value);
    
    int extractNumber(int *num, const char *pattern, std::string &variable,
                        std::string &value);
    
    std::vector<std::string> getWhiteList() { return _whitelist; };
    std::vector<std::string> getBlackList() { return _blacklist; };

    void dump();
    
private:
    int  _delay;                // the timer delay
    bool _debug;                // enable debugging of this class
    bool _debugger;             // enable the Flash movie debugger
    int  _verbosity;
    bool _actiondump;           // enable dumping actionscript classes
    bool _parserdump;           // enable dumping parser data
    
    // End user Features
    bool _splash_screen;        // display a splash screen when
                                // loading a movie
    // Security Features
    bool _localdomain_only;     // only access network resources for
                                // the local domain
    bool _localhost_only;       // only access network resources 
    std::vector<std::string> _whitelist; // domains we allow
    std::vector<std::string> _blacklist; // domains we don't allow
    std::string _log;           // the name of the debug log
    bool _writelog;             // enable writing the debug log to disk
    std::string _wwwroot;       // the root path for the streaming server
};

extern DSOEXPORT RcInitFile rcfile;

// End of gnash namespace 
}

// __RC_H__
#endif
