<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: EditUserTitle.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');

if ( !$permission->Check('user','enabled')
		OR !( $permission->Check('user','edit') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title',  TTi18n::gettext($title = 'Edit Employee Title')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'id',
												'title_data'
												) ) );

$utf = new UserTitleFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'submit':
		Debug::Text('Submit!', __FILE__, __LINE__, __METHOD__,10);

		$utf->setId($title_data['id']);
		$utf->setCompany( $current_company->getId() );
		$utf->setName($title_data['name']);

		if ( $utf->isValid() ) {
			$utf->Save();

			Redirect::Page( URLBuilder::getURL(NULL, 'UserTitleList.php') );

			break;
		}
	default:
		if ( isset($id) ) {
			BreadCrumb::setCrumb($title);

			$utlf = new UserTitleListFactory();

			$utlf->GetByIdAndCompanyId($id, $current_company->getId() );

			foreach ($utlf as $title_obj) {
				//Debug::Arr($title_obj,'Title Object', __FILE__, __LINE__, __METHOD__,10);

				$title_data = array(
									'id' => $title_obj->getId(),
									'name' => $title_obj->getName(),
									'created_date' => $title_obj->getCreatedDate(),
									'created_by' => $title_obj->getCreatedBy(),
									'updated_date' => $title_obj->getUpdatedDate(),
									'updated_by' => $title_obj->getUpdatedBy(),
									'deleted_date' => $title_obj->getDeletedDate(),
									'deleted_by' => $title_obj->getDeletedBy()
								);
			}
		}

		$smarty->assign_by_ref('title_data', $title_data);

		break;
}

$smarty->assign_by_ref('utf', $utf);

$smarty->display('users/EditUserTitle.tpl');
?>