<?php
/*********************************************************************************
 * The contents of this file are subject to the TimeTrex Public License Version
 * 1.1.0 ("License"); You may not use this file except in compliance with the
 * License. You may obtain a copy of the License at http://www.TimeTrex.com/TPL
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * All copies of the Covered Code must include on each user interface screen:
 *    (i) the "Powered by TimeTrex" logo and
 *    (ii) the TimeTrex copyright notice
 * in the same form as they appear in the distribution.  See full license for
 * requirements.
 *
 * The Original Code is: TimeTrex Open Source
 * The Initial Developer of the Original Code is TimeTrex Payroll Services
 * Portions created by TimeTrex are Copyright (C) 2004-2007 TimeTrex Payroll Services;
 * All Rights Reserved.
 *
 ********************************************************************************/
/*
 * $Revision: 1246 $
 * $Id: ViewPayPeriod.php 1246 2007-09-14 23:47:42Z ipso $
 * $Date: 2007-09-14 16:47:42 -0700 (Fri, 14 Sep 2007) $
 */
require_once('../../includes/global.inc.php');
require_once(Environment::getBasePath() .'includes/Interface.inc.php');
//require_once(Environment::getBasePath() .'classes/class.progressbar.php');

//Debug::setVerbosity(11);

if ( !$permission->Check('pay_period_schedule','enabled')
		OR !( $permission->Check('pay_period_schedule','edit') OR $permission->Check('pay_period_schedule','edit_own') ) ) {

	$permission->Redirect( FALSE ); //Redirect

}

$smarty->assign('title', TTi18n::gettext($title = 'View Pay Period')); // See index.php

/*
 * Get FORM variables
 */
extract	(FormVariables::GetVariables(
										array	(
												'action',
												'pay_period_id',
												'status_id'
												) ) );

$ppf = new PayPeriodFactory();

$action = Misc::findSubmitButton();
switch ($action) {
	case 'submit':
		$pplf = new PayPeriodListFactory();
		$pplf->getByIdAndCompanyId($pay_period_id, $current_company->getId() );
		foreach ($pplf as $pay_period_obj) {
			$pay_period_obj->setStatus( $status_id );
			$pay_period_obj->save();
		}

		Redirect::Page( URLBuilder::getURL( array('pay_period_id' => $pay_period_id), 'ViewPayPeriod.php') );

		break;
	case 'generate_paystubs':
		Debug::Text('Generate Pay Stubs!', __FILE__, __LINE__, __METHOD__,10);

		Redirect::Page( URLBuilder::getURL( array('action' => 'generate_paystubs', 'pay_period_ids' => $pay_period_id, 'next_page' => URLBuilder::getURL( array('filter_pay_period_id' => $pay_period_id ), '../pay_stub/PayStubList.php') ), '../progress_bar/ProgressBarControl.php') );

		break;
	case 'import':

		//Imports already created shifts in to this pay period, from another pay period.
		$udlf = new UserDateListFactory();

		//Get all users assigned to this pay period schedule.
		$pplf = new PayPeriodListFactory();
		$pay_period_obj = $pplf->getByIdAndCompanyId($pay_period_id, $current_company->getId() )->getCurrent();

		$pay_period_obj->getPayPeriodScheduleObject()->setPayPeriodTimeZone();
		$pay_period_users = $pay_period_obj->getPayPeriodScheduleObject()->getUser();

		$udlf->StartTransaction();
		$udlf->getByUserIdAndStartDateAndEndDate($pay_period_users, $pay_period_obj->getStartDate(), $pay_period_obj->getEndDate() );
		foreach($udlf as $ud_obj) {
			$new_pay_period_id = $ud_obj->findPayPeriod();
			Debug::Text('Current Pay Period: '. $ud_obj->getPayPeriod() .' ('.$pay_period_id .') New PayPeriod ID: '. $new_pay_period_id , __FILE__, __LINE__, __METHOD__,10);

			//Make sure original pay period isn't already closed
			if ( $pay_period_id == $new_pay_period_id
					AND $ud_obj->getPayPeriodObject()->getStatus() != 20) {
				$ud_obj->setPayPeriod( $new_pay_period_id );
				$ud_obj->Save();
			} else {
				Debug::Text('Pay Period is already closed, OR Current Pay Period DOES NOT match New PayPeriod ID!!', __FILE__, __LINE__, __METHOD__,10);
			}
			unset($new_pay_period_id);
		}
		//$udlf->FailTransaction();
		$udlf->CommitTransaction();

		Redirect::Page( URLBuilder::getURL( array('pay_period_id' => $pay_period_id), 'ViewPayPeriod.php') );

		break;

/*
	case 'open':
		$pplf = new PayPeriodListFactory();
		$pplf->getByIdAndCompanyId($pay_period_id, $current_company->getId() );
		foreach ($pplf as $pay_period_obj) {
			$pay_period_obj->setStatus(10);
			$pay_period_obj->save();
		}

		Redirect::Page( URLBuilder::getURL( array('pay_period_id' => $pay_period_id), 'ViewPayPeriod.php') );

		break;

	case 'approve':
		$pplf = new PayPeriodListFactory();
		$pplf->getByIdAndCompanyId($pay_period_id, $current_company->getId() );
		foreach ($pplf as $pay_period_obj) {
			$pay_period_obj->setStatus(15);
			$pay_period_obj->save();
		}

		Redirect::Page( URLBuilder::getURL( array('pay_period_id' => $pay_period_id), 'ViewPayPeriod.php') );

		break;
	case 'close':
		$pplf = new PayPeriodListFactory();
		$pplf->getByIdAndCompanyId($pay_period_id, $current_company->getId() );
		foreach ($pplf as $pay_period_obj) {
			$pay_period_obj->setStatus(20);
			$pay_period_obj->save();
		}

		Redirect::Page( URLBuilder::getURL( array('pay_period_id' => $pay_period_id), 'ViewPayPeriod') );

		break;
	*/
	default:
		if ( isset($pay_period_id) ) {
			BreadCrumb::setCrumb($title);

			$status_options = $ppf->getOptions('status');

			$pplf = new PayPeriodListFactory();
			$pplf->getByIdAndCompanyId($pay_period_id, $current_company->getId() );

			foreach ($pplf as $pay_period_obj) {
				//Debug::Arr($station,'Department', __FILE__, __LINE__, __METHOD__,10);

				$pay_period_data = array(
													'id' => $pay_period_obj->getId(),
													'company_id' => $pay_period_obj->getCompany(),
													'pay_period_schedule_id' => $pay_period_obj->getPayPeriodSchedule(),
													'pay_period_schedule_type' => $pay_period_obj->getPayPeriodScheduleObject()->getType(),
													'status_id' => $pay_period_obj->getStatus(),
													'status' => $status_options[$pay_period_obj->getStatus()],
													'start_date' => $pay_period_obj->getStartDate(),
													'end_date' => $pay_period_obj->getEndDate(),
													'transaction_date' => $pay_period_obj->getTransactionDate(),
													'is_primary' => $pay_period_obj->getPrimary(),

													'deleted' => $pay_period_obj->getDeleted(),
													'tainted' => $pay_period_obj->getTainted(),
													'tainted_date' => $pay_period_obj->getTaintedDate(),
													'tainted_by' => $pay_period_obj->getTaintedBy(),
													'created_date' => $pay_period_obj->getCreatedDate(),
													'created_by' => $pay_period_obj->getCreatedBy(),
													'updated_date' => $pay_period_obj->getUpdatedDate(),
													'updated_by' => $pay_period_obj->getUpdatedBy(),
													'deleted_date' => $pay_period_obj->getDeletedDate(),
													'deleted_by' => $pay_period_obj->getDeletedBy()
												);
			}
			Debug::Text('Current Pay Period Status: '. $pay_period_obj->getStatus(), __FILE__, __LINE__, __METHOD__,10);

			$status_options = $pay_period_obj->getOptions('status');

			if ( $pay_period_obj->getStatus() == 20
					OR $pay_period_obj->getStatus() == 30 ) {
				//Once pay period is closed, do not allow it to re-open.
				$status_filter_arr = array(20,30);
			} else {
				//Only allow to close pay period if AFTER end date.
				if ( TTDate::getTime() >= $pay_period_obj->getEndDate() ) {
					$status_filter_arr = array(10,12,$pay_period_obj->getStatus(), 20);
				} else {
					$status_filter_arr = array(10,12,$pay_period_obj->getStatus() );
				}
			}

			$status_options = Option::getByArray( $status_filter_arr, $status_options);

			$smarty->assign_by_ref('status_options', $status_options);

			$elf = new ExceptionListFactory();
			$elf->getSumExceptionsByPayPeriodIdAndBeforeDate($pay_period_obj->getId(), $pay_period_obj->getEndDate() );
			$exceptions = array(
								'low' => 0,
								'med' => 0,
								'high' => 0,
								);
			if ( $elf->getRecordCount() > 0 ) {
				Debug::Text(' Found Exceptions: '. $elf->getRecordCount(), __FILE__, __LINE__, __METHOD__,10);
				foreach($elf as $e_obj ) {
					if ( $e_obj->getColumn('severity_id') == 10 ) {
						$exceptions['low'] = $e_obj->getColumn('count');
					}
					if ( $e_obj->getColumn('severity_id') == 20 ) {
						$exceptions['med'] = $e_obj->getColumn('count');
					}
					if ( $e_obj->getColumn('severity_id') == 30 ) {
						$exceptions['high'] = $e_obj->getColumn('count');
					}

				}
			} else {
				Debug::Text(' No Exceptions!', __FILE__, __LINE__, __METHOD__,10);
			}

			//Get all pending requests
			$pending_requests = 0;
			$rlf = new RequestListFactory();
			$rlf->getSumByPayPeriodIdAndStatus( $pay_period_obj->getId(), 30 );
			if ( $rlf->getRecordCount() > 0 ) {
				$pending_requests = $rlf->getCurrent()->getColumn('total');
			}
			$pay_period_data['pending_requests'] = $pending_requests;

			//Count how many punches are in this pay period.
			$plf = new PunchListFactory();
			$pay_period_data['total_punches'] = $plf->getByPayPeriodId( $pay_period_id )->getRecordCount();
			Debug::Text(' Total Punches: '. $pay_period_data['total_punches'], __FILE__, __LINE__, __METHOD__,10);
		}
		//var_dump($pay_period_data);

		$smarty->assign_by_ref('exceptions', $exceptions);
		$smarty->assign_by_ref('pay_period_data', $pay_period_data);
		$smarty->assign_by_ref('current_epoch', TTDate::getTime() );

		break;
}

$smarty->assign_by_ref('ppf', $ppf);

$smarty->display('payperiod/ViewPayPeriod.tpl');
?>