/*
 * gAcc_editacc.c
 * Thomas Nemeth, le 10.12.1999
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include "defines.h"
#include "structs.h" 
#include "gAcc_editacc.h"
#include "acclists.h"
#include "accounts.h"
#include "tiers.h"
#include "locale_formats.h"
#include "gAcc.h"
#include "gAcc_msg.h"


/*** Create the "Edit Account" dialog box ****************************/

void editacc_ok_cb (GtkWidget *widget, void *data) {
    MY_LIST   *list           = (MY_LIST *)   data;
    GtkWidget *window         = (GtkWidget *) my_list_get_element (list, 0);
    GtkWidget *editacc_name   = (GtkWidget *) my_list_get_element (list, 1);
    GtkWidget *editacc_bank   = (GtkWidget *) my_list_get_element (list, 2);
    GtkWidget *editacc_num    = (GtkWidget *) my_list_get_element (list, 3);
    GtkWidget *editacc_date   = (GtkWidget *) my_list_get_element (list, 4);
    GtkWidget *editacc_amount = (GtkWidget *) my_list_get_element (list, 5);
    ACCOUNT   *account        = (ACCOUNT   *) my_list_get_element (list, 6);
    char      *name;
    char      *number;
    char      *bank;
    char      *date;
    float      amount;

    name   = gtk_entry_get_text (GTK_ENTRY (editacc_name) );
    number = gtk_entry_get_text (GTK_ENTRY (editacc_num) );
    bank   = gtk_entry_get_text (GTK_ENTRY (editacc_bank) );
    date   = unformat_date (gtk_entry_get_text (GTK_ENTRY (editacc_date) ) );
    amount = get_amount (gtk_entry_get_text (GTK_ENTRY (editacc_amount) ) );

    if ( (strcmp (name, "")   == 0) ||
         (strcmp (number, "") == 0) ) {
        GtkWidget *msg_dialog = create_msg_dialog (
            _(" You should provide a name and a number for this account ! ") );
        gtk_window_set_modal (GTK_WINDOW (msg_dialog), TRUE);
        gtk_widget_show (GTK_WIDGET (msg_dialog) );
        return;
    }

    if (account == NULL) {
        TIERS *tiers = tiers_new ();
        trs_set_name (tiers, name);
        trs_set_flag (tiers, VRAI);
        trs_set_num  (tiers, get_tiers_next_num () );
        account = account_new ();
        add_account (account);
        add_tiers (tiers);
    } else {
        TRS_ELT *trs = get_tiers_with_name (account->name);
        if ( (trs != NULL) && (strcmp (account->name, name) != 0) ) {
            trs_set_name (trs->tiers, name);
        }
    }

    acc_set_name    (account, name);
    acc_set_num     (account, number);
    acc_set_bank    (account, bank);
    acc_set_date    (account, date);
    acc_set_amount  (account, amount);

    gtk_widget_destroy (window);
    free (date);
    my_list_free (list);
    set_acc_list (acc_clist);
}

void editacc_cancel_cb (GtkWidget *widget, void *data) {
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
}

GtkWidget *create_editacc_dialog (ACCOUNT *account) {
    GtkWidget *EditAcc_Dialog;
    GtkWidget *bouton;
    GtkWidget *label;
    GtkWidget *vbox;
    GtkWidget *hbox;
    GtkWidget *editacc_name;
    GtkWidget *editacc_bank;
    GtkWidget *editacc_num;
    GtkWidget *editacc_date;
    GtkWidget *editacc_amount;
    MY_LIST   *list = NULL;

    EditAcc_Dialog = gtk_dialog_new ();
    list = my_list_add (list, EditAcc_Dialog);
    gtk_signal_connect (GTK_OBJECT (EditAcc_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                        NULL);
    gtk_signal_connect (GTK_OBJECT (EditAcc_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);

    bouton = gtk_button_new_with_label ( _("OK") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (editacc_ok_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (EditAcc_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_grab_default (GTK_WIDGET (bouton) );
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label ( _("Cancel") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (editacc_cancel_cb),
                        list);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (EditAcc_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    /* Left Side */
    vbox = gtk_vbox_new (TRUE, 3);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 3);

    /* Name */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Name : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 3);
    gtk_widget_show (label);

    editacc_name = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), editacc_name, TRUE, TRUE, 3);
    gtk_widget_show (editacc_name);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 3);
    gtk_widget_show (hbox);
    /* - */

    /* Bank */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Bank : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 3);
    gtk_widget_show (label);

    editacc_bank = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), editacc_bank, TRUE, TRUE, 3);
    gtk_widget_show (editacc_bank);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 3);
    gtk_widget_show (hbox);
    /* - */

    /* Number */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Number : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 3);
    gtk_widget_show (label);

    editacc_num = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), editacc_num, TRUE, TRUE, 3);
    gtk_widget_show (editacc_num);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 3);
    gtk_widget_show (hbox);
    /* - */

    /* Opening Balance */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Opening balance : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 3);
    gtk_widget_show (label);

    editacc_amount = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), editacc_amount, TRUE, TRUE, 3);
    gtk_widget_show (editacc_amount);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 3);
    gtk_widget_show (hbox);
    /* - */

    /* Date */
    hbox = gtk_hbox_new (TRUE, 0);

    label = gtk_label_new (_("Creation date : ") );
    gtk_box_pack_start (GTK_BOX (hbox), label, TRUE, TRUE, 3);
    gtk_widget_show (label);

    editacc_date = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), editacc_date, TRUE, TRUE, 3);
    gtk_widget_show (editacc_date);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 3);
    gtk_widget_show (hbox);
    /* - */

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (EditAcc_Dialog)->vbox), vbox,
                        TRUE, TRUE, 3);
    gtk_widget_show (vbox);

    if (account == NULL) {
        char      *today;
        gtk_entry_set_text (GTK_ENTRY (editacc_name), "");
        gtk_entry_set_text (GTK_ENTRY (editacc_bank), "");
        gtk_entry_set_text (GTK_ENTRY (editacc_num), "");
        today = format_today ();
        gtk_entry_set_text (GTK_ENTRY (editacc_date), today);
        gtk_entry_set_text (GTK_ENTRY (editacc_amount), "0.0");
        free (today);
    } else {
        char      *amount;
        char      *date;
        gtk_entry_set_text (GTK_ENTRY (editacc_name),
                            account->name != NULL ? account->name : "");
        gtk_entry_set_text (GTK_ENTRY (editacc_bank),
                            account->bank != NULL ? account->bank : "");
        gtk_entry_set_text (GTK_ENTRY (editacc_num),
                            account->num != NULL ? account->num : "");
        date = format_date (account->date);
        gtk_entry_set_text (GTK_ENTRY (editacc_date), date);
        amount = format_amount (account->amount);
        gtk_entry_set_text (GTK_ENTRY (editacc_amount), amount);
        free (amount);
        free (date);
    }

    gtk_widget_grab_focus (GTK_WIDGET (editacc_name) );
    gtk_widget_draw_focus (GTK_WIDGET (editacc_name) );

    list = my_list_add (list, editacc_name);
    list = my_list_add (list, editacc_bank);
    list = my_list_add (list, editacc_num);
    list = my_list_add (list, editacc_date);
    list = my_list_add (list, editacc_amount);
    list = my_list_add (list, account);

    return EditAcc_Dialog;
}
