/* Automatically generated from Squeak on #(23 July 2001 3:01:22 pm) */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* Default EXPORT macro that does nothing (see comment in sq.h): */
#define EXPORT(returnType) returnType

/* Do not include the entire sq.h file but just those parts needed. */
/*  The virtual machine proxy definition */
#include "sqVirtualMachine.h"
/* Configuration options */
#include "sqConfig.h"
/* Platform specific definitions */
#include "sqPlatformSpecific.h"

#define true 1
#define false 0
#define null 0  /* using 'null' because nil is predefined in Think C */
#include "JoystickTabletPlugin.h"

/* memory access macros */
#define byteAt(i) (*((unsigned char *) (i)))
#define byteAtput(i, val) (*((unsigned char *) (i)) = val)
#define longAt(i) (*((int *) (i)))
#define longAtput(i, val) (*((int *) (i)) = val)

/*** Variables ***/
static struct VirtualMachine* interpreterProxy;
static const char *moduleName = "JoystickTabletPlugin 23 July 2001 (i)";

/*** Function Prototypes ***/
#pragma export on
EXPORT(const char*) JoystickTabletPlugin_getModuleName(void);
EXPORT(int) JoystickTabletPlugin_initialiseModule(void);
EXPORT(int) JoystickTabletPlugin_primitiveGetTabletParameters(void);
EXPORT(int) JoystickTabletPlugin_primitiveReadJoystick(void);
EXPORT(int) JoystickTabletPlugin_primitiveReadTablet(void);
EXPORT(int) JoystickTabletPlugin_setInterpreter(struct VirtualMachine* anInterpreter);
EXPORT(int) JoystickTabletPlugin_shutdownModule(void);
#pragma export off


/*	Note: This is hardcoded so it can be run from Squeak.
	The module name is used for validating a module *after*
	it is loaded to check if it does really contain the module
	we're thinking it contains. This is important! */

EXPORT(const char*) JoystickTabletPlugin_getModuleName(void) {
	return moduleName;
}

EXPORT(int) JoystickTabletPlugin_initialiseModule(void) {
	return joystickInit();
}


/*	Get information on the pen tablet attached to this machine. Fail if there is no tablet. If successful, the result is an array of integers; see the Smalltalk call on this primitive for its interpretation. */

EXPORT(int) JoystickTabletPlugin_primitiveGetTabletParameters(void) {
	int * resultPtr;
	int resultSize;
	int result;
	int cursorIndex;

	cursorIndex = interpreterProxy->stackIntegerValue(0);
	if (interpreterProxy->failed()) {
		return null;
	}
	resultSize = tabletResultSize();
	result = interpreterProxy->instantiateClassindexableSize(interpreterProxy->classBitmap(), resultSize);
	resultPtr = (int *) interpreterProxy->firstIndexableField(result);
	interpreterProxy->success(tabletGetParameters(cursorIndex, resultPtr));
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->popthenPush(2, result);
	return null;
}


/*	Read an input word from the joystick with the given index. */

EXPORT(int) JoystickTabletPlugin_primitiveReadJoystick(void) {
	int index;
	int _return_value;

	index = interpreterProxy->stackIntegerValue(0);
	if (interpreterProxy->failed()) {
		return null;
	}
	_return_value = interpreterProxy->positive32BitIntegerFor((joystickRead(index)));
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->popthenPush(2, _return_value);
	return null;
}


/*	Get the current state of the cursor of the pen tablet specified by my argument. Fail if there is no tablet. If successful, the result is an array of integers; see the Smalltalk call on this primitive for its interpretation. */

EXPORT(int) JoystickTabletPlugin_primitiveReadTablet(void) {
	int * resultPtr;
	int resultSize;
	int result;
	int cursorIndex;

	cursorIndex = interpreterProxy->stackIntegerValue(0);
	if (interpreterProxy->failed()) {
		return null;
	}
	resultSize = tabletResultSize();
	result = interpreterProxy->instantiateClassindexableSize(interpreterProxy->classBitmap(), resultSize);
	resultPtr = (int *) interpreterProxy->firstIndexableField(result);
	interpreterProxy->success(tabletRead(cursorIndex, resultPtr));
	if (interpreterProxy->failed()) {
		return null;
	}
	interpreterProxy->popthenPush(2, result);
	return null;
}


/*	Note: This is coded so that is can be run from Squeak. */

EXPORT(int) JoystickTabletPlugin_setInterpreter(struct VirtualMachine* anInterpreter) {
	int ok;

	interpreterProxy = anInterpreter;
	ok = interpreterProxy->majorVersion() == VM_PROXY_MAJOR;
	if (ok == 0) {
		return 0;
	}
	ok = interpreterProxy->minorVersion() >= VM_PROXY_MINOR;
	return ok;
}

EXPORT(int) JoystickTabletPlugin_shutdownModule(void) {
	return joystickShutdown();
}
