#define GKRELLM_THREADS

/* Stuff to implement threads, borrowed from testgthread.c in glib.
|  The defaults there are joinable threads.  Here I use detached threads,
|  so can't use the join_thread() macros.
*/
#if defined(G_THREADS_IMPL_NSPR)    
#warning "note, that you have to link with whatever library"
#warning "nspr is building upon, it might otherwise (as on solaris) lead to"
#warning "run time failure, as the mutex functions are defined in libc, but"
#warning "as noops, that will make some nspr assertions fail."
#include <prthread.h>

static gpointer
new_thread (GHookFunc func, gpointer data)
	{
	PRThread *thread = PR_CreateThread (PR_SYSTEM_THREAD, func, data,
				PR_PRIORITY_NORMAL, PR_LOCAL_THREAD,
				PR_UNJOINABLE_THREAD, 0);
	return thread;
	}

#define join_thread(thread) PR_JoinThread (thread)
#define self_thread() PR_GetCurrentThread ()

#elif defined(G_THREADS_IMPL_SOLARIS)   
#include <thread.h>

static gpointer
new_thread (GHookFunc func, gpointer data)
	{
	thread_t thread;

	thr_create(NULL, 0, (void *(*)(void *)) func, data, THR_DETACHED, &thread);
	return GUINT_TO_POINTER (thread);
	}
#define join_thread(thread) \
	thr_join ((thread_t)GPOINTER_TO_UINT (thread), NULL, NULL)
#define self_thread()  GUINT_TO_POINTER (thr_self ())

#elif defined(G_THREADS_IMPL_POSIX)
#include <pthread.h>

static gpointer
new_thread(GHookFunc func, gpointer data)
	{
	pthread_t thread;
	pthread_attr_t pthread_attr;

	pthread_attr_init (&pthread_attr);
	pthread_attr_setdetachstate(&pthread_attr, PTHREAD_CREATE_DETACHED);
	pthread_create (&thread, &pthread_attr, (void *(*)(void *)) func, data);
	return GUINT_TO_POINTER (thread);
	}

#define join_thread(thread) \
	pthread_join ((pthread_t)GPOINTER_TO_UINT (thread), NULL)
#define self_thread() GUINT_TO_POINTER (pthread_self ())

#else /* no thread implementation, do nothing */
#define new_thread(func,data) (NULL)
#define join_thread(thread) ((void)0)
#define self_thread() NULL
#undef GKRELLM_THREADS
#endif
