<?php
/**
 * Representation of a Kolab user group.
 *
 * $Horde: framework/Kolab_Server/lib/Horde/Kolab/Server/Object/group.php,v 1.2.2.2 2008/08/01 07:56:20 wrobel Exp $
 *
 * @package Kolab_Server
 */

/**
 * This class provides methods to deal with groups for Kolab.
 *
 * $Horde: framework/Kolab_Server/lib/Horde/Kolab/Server/Object/group.php,v 1.2.2.2 2008/08/01 07:56:20 wrobel Exp $
 *
 * Copyright 2008 The Horde Project (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Gunnar Wrobel  <wrobel@pardus.de>
 * @package Kolab_Server
 */
class Horde_Kolab_Server_Object_group extends Horde_Kolab_Server_Object {

    /**
     * The LDAP filter to retrieve this object type
     *
     * @var string
     */
    var $filter = '(&(!(cn=domains))(objectclass=kolabGroupOfNames))';

    /**
     * The attributes supported by this class
     *
     * @var array
     */
    var $_supported_attributes = array(
        KOLAB_ATTR_CN,
        KOLAB_ATTR_MAIL,
        KOLAB_ATTR_DELETED,
    );

};
