/*
    ettercap -- gtk interface for splash screen

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>
    GTK+ 2.0 interface by daten <daten@dnetc.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <ec_gtk_icons.h>
#include <ec_main.h>
#include <ec_version.h>
#include <ec_inet.h>
#include <ec_plugins.h>
#include <ec_gtk.h>

/* construct the splash screen */
void Ginterface_Splash_Init(void);

/* display the splash screen */
void Ginterface_Splash_Show(void);

/* run the init code after the splash is displayed */
void Ginterface_Splash_Run(GtkWidget *widget, gpointer data);

/* append a header label to the top */
void Ginterface_Splash_Header(gchar *mesg);

/* append a message or error */
void Ginterface_Splash_Append(gchar *mesg);

/* set the progress bar text */
void Ginterface_Splash_Progress(gchar *mesg);

/* change the progress bar precent */
/* value between 0.0 and 1.0 */
void Ginterface_Splash_Progress_Change(gdouble percent);

/* close the splash screen */
void Ginterface_Splash_Close(void);

GtkWidget *splash_win = NULL, *splash_image = NULL, *splash_pbar = NULL;
GtkWidget *splash_vbox = NULL, *splash_table = NULL, *splash_textview = NULL, *splash_scrolled = NULL;
GtkTextBuffer *splash_buffer = NULL;
GtkTextMark *splash_mark = NULL;


void Ginterface_Splash_Init(void) {
   GdkPixbuf *pixbuf;
   GtkTextIter iter;
   gchar line[200];

   DEBUG_MSG("Ginterface_Splash_Init");
        
   splash_win = gtk_dialog_new_with_buttons ("ettercap", NULL, GTK_DIALOG_MODAL, NULL);
   gtk_container_set_border_width (GTK_CONTAINER (splash_win), 10);
   gtk_window_set_default_size(GTK_WINDOW (splash_win), 300, 300);
   gtk_window_set_position (GTK_WINDOW (splash_win), GTK_WIN_POS_CENTER);
   gtk_dialog_set_has_separator (GTK_DIALOG (splash_win), FALSE);

   /* a table for layout */
   splash_table = gtk_table_new(3, 1, FALSE); /* 3 rows, 1 col, diff sizes */
   gtk_box_pack_start (GTK_BOX(GTK_DIALOG(splash_win)->vbox), splash_table, TRUE, TRUE, 0);
   gtk_widget_show(splash_table);

   /* box for top of table */
   splash_vbox = gtk_vbox_new(FALSE, 0);
   gtk_table_attach (GTK_TABLE (splash_table), splash_vbox, 0, 1, 0, 1, GTK_FILL | GTK_EXPAND, 0, 0, 0);
   gtk_widget_show(splash_vbox);

   /* splash image */
   pixbuf = gdk_pixbuf_new_from_inline (-1, ettercap_logo, FALSE, NULL);
   splash_image = gtk_image_new_from_pixbuf(pixbuf);
   gtk_box_pack_start (GTK_BOX(splash_vbox), splash_image, FALSE, FALSE, 0);
   gtk_widget_show(splash_image);

   /* splash headers */
   #if DEVEL_RELEASE == 1
      snprintf (line, 200, "%s %s beta %s (c) 2002 %s", PROGRAM, VERSION, RELEASE_DATE, AUTHORS);
      Ginterface_Splash_Header(line);
   #else
      snprintf (line, 200, "%s %s (c) 2002 %s", PROGRAM, VERSION, AUTHORS);
      Ginterface_Splash_Header(line);
   #endif

   snprintf (line, 200, "Your IP: %s with MAC: %s on Iface: %s\n", Inet_MyIPAddress(), Inet_MyMACAddress(), Options.netiface);
   Ginterface_Splash_Header(line);

   /* make a scrolled window for messages and errors */
   splash_scrolled = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (splash_scrolled), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
   gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (splash_scrolled), GTK_SHADOW_IN);
   gtk_table_attach (GTK_TABLE (splash_table), splash_scrolled, 0, 1, 1, 2, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 0, 0);
   gtk_widget_show (splash_scrolled);

   /* make a text view */
   splash_textview = gtk_text_view_new();
   gtk_text_view_set_editable(GTK_TEXT_VIEW(splash_textview), FALSE);
   splash_buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (splash_textview));
   gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER (splash_buffer), &iter);
   splash_mark = gtk_text_buffer_create_mark(splash_buffer, "end", &iter, FALSE);
   gtk_container_add(GTK_CONTAINER (splash_scrolled), splash_textview);
   gtk_widget_show(splash_textview);

   /* make the progress bar */
   splash_pbar = gtk_progress_bar_new ();
   gtk_table_attach (GTK_TABLE (splash_table), splash_pbar, 0, 1, 2, 3, GTK_FILL | GTK_EXPAND, 0, 0, 0);
   gtk_widget_show(splash_pbar);

   g_signal_connect_after(G_OBJECT(splash_win), "show", G_CALLBACK (Ginterface_Splash_Run), NULL);

   while (g_main_iteration(FALSE)); /* update gui */
}

void Ginterface_Splash_Run(GtkWidget *widget, gpointer data) {
   gchar line[200];

   DEBUG_MSG("Ginterface_Splash_Run");

   #ifdef PERMIT_PLUGINS
      Plugin_LoadAll();
   #endif

   snprintf(line, 200, "Building host list for netmask %s, please wait...", Inet_MySubnet());
   Ginterface_Splash_Header (line);

   number_of_hosts_in_lan = Inet_HostInLAN();

   Ginterface_Splash_Close();
   Ginterface_Screen_Init();
}

void Ginterface_Splash_Show(void) {
   DEBUG_MSG("Ginterface_Splash_Show");
   gtk_widget_show(splash_win);
}

/* this makes a new label in the splash window */
void Ginterface_Splash_Header(gchar *mesg) {
   GtkWidget *label;
   char *clean = NULL;

   if(!splash_win)
      return;

   clean = (mesg[0] == '\n')? mesg + 1 : mesg;
        
   label = gtk_label_new (clean);
   gtk_box_pack_start (GTK_BOX(splash_vbox), label, FALSE, FALSE, 0);
   gtk_widget_show(label);

   while (g_main_iteration(FALSE)); /* update gui */
}

void Ginterface_Splash_Append(gchar *mesg) {
   GtkTextIter iter;

   if(mesg == NULL || strlen(mesg) < 1)
      return; 
        
   gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER (splash_buffer), &iter);
   gtk_text_buffer_insert(GTK_TEXT_BUFFER (splash_buffer), &iter,
      g_locale_to_utf8 (mesg, strlen(mesg), NULL, NULL, NULL), -1);

   gtk_text_view_scroll_to_mark(GTK_TEXT_VIEW(splash_textview), splash_mark, 0, FALSE, 0, 0);

   while (g_main_iteration(FALSE)); /* update gui */
}

/* this makes a new label and progress bar in the splash window */
void Ginterface_Splash_Progress(gchar *mesg) {
   if(!splash_pbar)
      return;

   if(mesg == NULL || strlen(mesg) < 1)
      return;

   gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (splash_pbar), 0.0);
   gtk_progress_bar_set_text (GTK_PROGRESS_BAR (splash_pbar), mesg);
   Ginterface_Splash_Append(mesg);
   Ginterface_Splash_Append("\n");
        
   while (g_main_iteration(FALSE)); /* update gui */
}

void Ginterface_Splash_Progress_Change(gdouble percent) {
   if(!splash_pbar || percent < 0.0 || percent > 1.0)
         return;

   gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (splash_pbar), percent);
   while (g_main_iteration(FALSE)); /* update gui */
}

void Ginterface_Splash_Close(void) {
   DEBUG_MSG("Ginterface_Splash_Close");
   gtk_widget_hide (splash_win);
   gtk_widget_destroy (splash_pbar);
   gtk_widget_destroy (splash_win);

   splash_win = NULL;
   splash_pbar = NULL;

   while (g_main_iteration(FALSE)); /* update gui */
}

/* EOF */

// vim:ts=3:expandtab
