
/* $Id: ec_main.h,v 1.68 2003/05/28 10:10:53 lordnaga Exp $ */


#if !defined(EC_MAIN_H)
#define EC_MAIN_H


#ifdef HAVE_CONFIG_H
   #include <config.h>     // autoheader   -I.
#endif

#define PROGRAM         "ettercap"
#define AUTHORS         "ALoR & NaGA"

#define LOOP for(;;)

#ifdef CYGWIN
   #include <windows.h>
   #include <winsock2.h> // this include must be the first !! cygwin sux !
#else
   #include <sys/types.h>
   #include <sys/time.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#if defined (LINUX) && !defined (__USE_GNU)  // for memmem(), strsignal(), etc etc...
   #define __USE_GNU
#endif
#include <string.h>
#if defined (__USE_GNU)
   #undef __USE_GNU
#endif
#include <strings.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>
#include "ec_queue.h"
#include "ec_error.h"
#include "ec_debug.h"

#include "ec_stdint.h"


#ifdef HAVE_PDCURSES
   #undef MOUSE_MOVED
#endif

#ifndef HAVE_STRLCAT             // missing functions
   #include "../missing/strlcat.h"
#endif
#ifndef HAVE_STRLCPY             // missing functions
   #include "../missing/strlcpy.h"
#endif
#ifndef HAVE_STRSEP              // missing functions
   #include "../missing/strsep.h"
#endif
#ifndef HAVE_STRCASESTR          // missing functions
   #include "../missing/strcasestr.h"
#endif
#ifndef HAVE_MEMMEM              // missing functions
   #include "../missing/memmem.h"
#endif
#ifndef HAVE_SCANDIR             // missing functions
   #include "../missing/scandir.h"
#endif

#if defined (CYGWIN)
   #define exit_func(x) atexit((void (*)(void))x)
   #define exit_func_end()
#else
   #define exit_func(x)    pthread_cleanup_push(x, (void *)NULL)
   #define exit_func_end() pthread_cleanup_pop(0)
#endif

typedef struct host_arp          // hosts in LAN info
{
   int port;
   char name[128];
   char ip[16];
   char mac[20];
} HOST;


extern HOST *Host_In_LAN;
extern int number_of_hosts_in_lan;

extern HOST Host_Source;
extern HOST Host_Dest;

typedef struct options_list      // arguments passed on command line
{
   char list:1;            // list of hosts in the lan
   char arpsniff:1;        // sniffing methods
   char sniff:1;
   char macsniff:1;
   char normal:1;          // no ncurses
   char gtk:1;             // GTK 2 interface
   char onscreen:1;        // 1 when ncurses screen is inizialized
   char check:1;           // check for other poisoners
   char plugin:1;
   char hexview:1;
   char textview:1;
   char ebcdicview:1;
   char silent:1;          // no ARP storm on startup
   char udp:1;             // which packet to sniff ?
   char tcp:1;
   char finger:1;          // active fingerprinting
   char link:1;            // test the link type (switch or hub)
   char collect:1;         // collect USER and PASS
   char broadping:1;       // uses ICMP instead of ARP to scan the lan
   char logtofile:1;
   char quiet:1;           // demonization
   char dontresolve:1;     // dont resolve host names
   char filter:1;
   char version:1;         // checks for new version
   char yes:1;             // answer yes to questions of version
   char reverse;           // all the connection BUT this (reverse matching)
   char passive:1;         // passive OS fingerprint
   char hostsfromfile:1;   // load the list from a file
   char hoststofile:1;     // save the host list to a file
   char *hostfile;
   char netiface[10];      // the name of the selected interface
   char netmask[16];
   char writedump:1;			// dump the file
   char *dumpfile;         // the tcpdump file format for offline analysis
   char onlypoison:1;
   char force_ip:1;        // doppleganter spoofed icmp
   short delay;            // delay between ARP replies
   u_long spoofIp;         // the IP used to spoof the ARP request
   int storm_delay;        // delay between ARP request on startup
   int refresh_delay;
   unsigned int buflen;
} OPTIONS;

extern OPTIONS Options;

struct open_ports
{
   u_short port;
   char banner[150];
   LIST_ENTRY (open_ports) next;
};


#define FINGER_LEN 28

typedef struct passive_data
{
   char ip[16];
   char mac[20];
   char fingerprint[FINGER_LEN+1];
   char os[60];
   char type[5];
   char gwforthis[16];
   char name[18];
   u_short port;
   char proto;
   short hop;
   char banner[150];
   LIST_HEAD (,open_ports) tcp_ports;
   LIST_HEAD (,open_ports) udp_ports;
} PASSIVE_DATA;

extern PASSIVE_DATA *Passive_Host;
extern int number_of_passive_hosts;


#define MAX_DATA 2000

typedef struct sniffed_data   // data through the pipe with illithid
{
   char source_ip[16];
   char dest_ip[16];
   u_long fast_source_ip;
   u_long fast_dest_ip;
   u_short source_port;
   u_short dest_port;
   u_long seq;
   u_long ack_seq;
   char flags;
   char proto;
   short datasize;
   char data[MAX_DATA];     // FIXME: to be resized...
} SNIFFED_DATA;


typedef struct current_sniffed_data
{
   u_long source_ip;
   u_long dest_ip;
   u_short source_port;
   u_short dest_port;
   char proto;
} CURRENT_SNIFFED_DATA;

extern CURRENT_SNIFFED_DATA current_illithid_data;

typedef struct {
   int Host_Index1;
   int Host_Index2;
   u_char mode;
} SniffingHost;


typedef struct connection        // connection list
{
   char source_ip[16];
   char dest_ip[16];
   char source_mac[20];
   char dest_mac[20];
   u_long fast_source_ip;
   u_long fast_dest_ip;
   u_short source_port;
   u_short dest_port;
   u_long source_seq;
   u_long dest_seq;
   char flags;
   char proto;
   short datalen;
   char status[8];
   char *DataBuffer;
   time_t timestamp;
   char type[18];          // from /etc/services
   char user[50];          // pay attention on buffer overflow !!
   char pass[50];
   char info[150];         // additional info... ( smb domain, http page ...)
} CONNECTION;


typedef struct dissect     // structs to be passed to Plugin_HookPoint
{
   u_char *layer4;
   CONNECTION *connection;
} DISSECTION;

typedef struct raw_pck
{
   u_char *buffer;
   int *len;
} RAW_PACKET;


#define MAX_INJECT 1000          // max number of injected chars
#define MAX_FILTER 200           // max filter length

typedef struct {                 // filter structure (ec_filterdrop.c)
   u_char display_search[MAX_FILTER+1];
   u_char display_replace[MAX_FILTER+1];
   char proto;
   int source;
   int dest;
   u_char search[MAX_FILTER+1];
   short slen;
   short wildcard;
   char type;
   u_char replace[MAX_FILTER+1];
   short rlen;
   int go_to;
   int else_go_to;
   char validate;
} DROP_FILTER;

extern DROP_FILTER *Filter_Array_Source;  // ec_filterdrop.c
extern DROP_FILTER *Filter_Array_Dest;
extern int Filter_Source;
extern int Filter_Dest;

typedef struct {                 // injecting structure
   u_long source_ip;
   u_long dest_ip;
   u_short source_port;
   u_short dest_port;
   char proto;
   char data[MAX_INJECT+1];
   short datalen;
} INJECTED_DATA;

typedef struct {                 // killing structure
   u_long source_ip;
   u_long dest_ip;
   u_short source_port;
   u_short dest_port;
} KILL_DATA;

extern CONNECTION *Conn_Between_Hosts;
extern int number_of_connections;

extern int pipe_with_illithid_data;
extern int pipe_with_plugins;
extern int pipe_inject[2];
extern int pipe_kill[2];

extern char active_dissector;    // ec_main.c
extern char filter_on_source;
extern char filter_on_dest;
extern int Connection_Mode;      // ec_illithid.c

#ifdef CYGWIN 				// damned cygwin include...
struct timezone {
  int tz_minuteswest;
  int tz_dsttime;
};

int gettimeofday(struct timeval *__p, struct timezone *__z);
#endif

#ifdef CYGWIN
   #define TIME_DECLARE float start, finish
   #define TIME_START   start=GetTickCount()
   #define TIME_FINISH  finish=GetTickCount()
   #define TIME_ELAPSED ((finish-start)/1.0e3)          // GetTickCount returns milliseconds
#elif defined(HAVE_GETTIMEOFDAY)
   #define TIME_DECLARE struct timeval start, finish
   #define TIME_START   gettimeofday(&start, 0)
   #define TIME_FINISH  gettimeofday(&finish, 0)
   #define TIME_ELAPSED (finish.tv_sec + finish.tv_usec/1.0e6)-(start.tv_sec  + start.tv_usec/1.0e6)
#else
   #define TIME_DECLARE float start, finish
   #define TIME_START   start=clock()
   #define TIME_FINISH  finish=clock()
   #define TIME_ELAPSED ((finish-start)/CLOCKS_PER_SEC)
#endif


#define ARPBASED  0  // illithid modus operandi
#define PUBLICARP 1
#define IPBASED   2
#define MACBASED  3


#if defined (HAVE_OPENSSL) && defined (PERMIT_HTTPS)
   #define HTTPS_Local_Port (unsigned short)1012         // local port for HTTPS dissection
   #define Proxy_Local_Port (unsigned short)1013
   #define CERT_FILE "etter.ssl.crt"
#endif


#define DEFAULT_DELAY 30            // in seconds, delay between arp replies
#define DEFAULT_STORM_DELAY 1500    // in microseconds, delay between inizial arp request
#define DEFAULT_BUFLEN 3
#define MAX_BUFLEN 200
#define DEFAULT_REFRESH_DELAY 300

#include "ec_install_path.h"

#define OS_FILE "etter.passive.os.fp"

#define CONN_TIME_SILENT   1        // in seconds, the time to change the connection status from ACTIVE to silent
#define CONN_TIME_TIMEOUT  1200


#endif   // EC_MAIN_H

/* EOF */

// vim:ts=3:expandtab

