/*
    ettercap -- dissector MSN -- TCP 1863

    Copyright (C) 2001  ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    $Id: ec_dissector_msn.c,v 1.3 2002/04/16 18:35:11 alor Exp $
*/

#include "include/ec_main.h"

#include "include/ec_dissector.h"
#include "include/ec_decodedata.h"
#include "include/ec_inet_structures.h"

// protos

FUNC_DISSECTOR(Dissector_msn);

// --------------------

FUNC_DISSECTOR(Dissector_msn)
{

   TCP_header *tcp;
   u_char *payload;
   u_char collector[MAX_DATA];
   ONLY_CONNECTION;

   tcp = (TCP_header *) data;

   if (data_to_ettercap->datalen == 0) return 0;      // no data...

   payload = (char *)((int)tcp + tcp->doff * 4);

   memset(collector, 0, MAX_DATA);
   memcpy(collector, payload, data_to_ettercap->datalen);

   /* the client send its username (email) */
   
   if ( (Dissector_StateMachine_GetStatus(data_to_ettercap, NULL) == 0) && ntohs(tcp->dest) == SERV_PORT)  {
      char *p;

      p = strstr(collector, "MD5 I");
      if (!p) return 0;
      
      DEBUG_MSG("MSN username");
      
      p = p + strlen("MD5 I ");
      
      snprintf(data_to_ettercap->user, sizeof(data_to_ettercap->user), "%s\n", p);
      data_to_ettercap->user[sizeof(data_to_ettercap->user)-2] = '\n';
      data_to_ettercap->user[sizeof(data_to_ettercap->user)-1] = '\0';
      
      sprintf(data_to_ettercap->type, "MSN messenger");
      
      Dissector_StateMachine_SetStatus(data_to_ettercap, 1, NULL);
      return 0; 
   }
   
   /* server messages... collect the MD5 challenge */
           
   if ( (Dissector_StateMachine_GetStatus(data_to_ettercap, NULL) == 1) && ntohs(tcp->source) == SERV_PORT) {
 
      char *p;
      int i;

      p = strstr(collector, "MD5 S");
      if (!p) return 0;
      
      DEBUG_MSG("MSN challenge");
      
      p = p + strlen("MD5 S ");
      
      for(i=0; i<strlen(p); i++)
         if (p[i] == '\r')
            p[i] = '\0';
      
      snprintf(data_to_ettercap->info, sizeof(data_to_ettercap->info), "Server MD5 challenge : %s\n", p);
      data_to_ettercap->info[sizeof(data_to_ettercap->info)-2] = '\n';
      data_to_ettercap->info[sizeof(data_to_ettercap->info)-1] = '\0';
      
      Dissector_StateMachine_SetStatus(data_to_ettercap, 2, NULL);
      return 0;
   } 
   
   /* the client reply with the MD5 password */

   if ( (Dissector_StateMachine_GetStatus(data_to_ettercap, NULL) == 2) && ntohs(tcp->dest) == SERV_PORT) {
      
      char *p;

      p = strstr(collector, "MD5 S");
      if (!p) return 0;
      
      DEBUG_MSG("MSN password");
      
      p = p + strlen("MD5 S ");
      
      snprintf(data_to_ettercap->pass, sizeof(data_to_ettercap->pass), "%s\n", p);
      data_to_ettercap->pass[sizeof(data_to_ettercap->pass)-2] = '\n';
      data_to_ettercap->pass[sizeof(data_to_ettercap->pass)-1] = '\0';
      
      Dissector_StateMachine_SetStatus(data_to_ettercap, 0, NULL);
      return 0;
    }

    return 0;
}

/* EOF */

// vim:ts=3:expandtab

