/*
    ettercap -- dissector for Quake3 -- UDP 27960 up to 27963 

    Copyright (C) 2001 ALoR <alor@users.sourceforge.net>, NaGA <crwm@freemail.it>

    Additional Copyright for this file:  LnZ Lorenzo Porro <lporro@libero.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

//It should work with all the games based on Q3 protocol, you probably
//will have to change the UDP ports

#include "include/ec_main.h"

#include "include/ec_dissector.h"
#include "include/ec_inet_structures.h"

#define Q3_CHECK 0xff

//protos

FUNC_DISSECTOR(Dissector_quake3);


// --------------------------------------


FUNC_DISSECTOR(Dissector_quake3)
{
   u_char *payload;
   UDP_header *udp;
   int i = 0;
   ONLY_CONNECTION;
  
   udp = (UDP_header *) data;
   
   //Let's check if it is really a quake3 packet
   payload = (char *)( (int) udp + UDP_HEADER);
   
   for (i=0; i<4; i++)
      if (payload[i] != Q3_CHECK)
         return 0; // not a Q3 packet
  
   payload += 4; //Firsts 4 bytes are always 0xff
  
   if(!strncasecmp(payload,"rcon",4))
   {
      int len = 0;
      
      DEBUG_MSG("\tDissector_quake3 -- [%s]", payload);
      
      //Let's get the password
      payload += 5;
     
      while( payload[len++] != ' ' && len < 28 );
      
      sprintf(data_to_ettercap->user, "Quake 3");
      strlcpy(data_to_ettercap->pass, payload, len); 
      strlcat(data_to_ettercap->pass, "\n", sizeof(data_to_ettercap->pass));

   }
   return 0;   
}

/* EOF */

// vim:ts=3:expandtab
