/*
 * Copyright (c) 1996, 1997, 1998, 2000, Mark Buser.
 * Copyright (c) 2003, 2004, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/rate.h,v 3.8 2004/04/24 07:58:40 danny Exp $
 */
#ifndef RATE_H
#define RATE_H

#include "nav.h"
#include "transP.h"

typedef struct {
  double div;
  double value;
  double yield;    /* yield over period */
  double annYield; /* yield annualized */
} YIELD;

#define CURRENT_DATE -1
#define FIRST_DATE    0
#define LAST_DATE     1

void rateAddTrans( TRANS *, int, double); /* Add one transaction to deposits  */
void rateClrTrans();                 /* Clear all deposits                    */
void rateClrAccount();               /* Clear all deposits                    */
double rate_IRR ( double );          /* IRR of deposits to reach parameter    */

double rate_datenum( int, long, long); /* number of days with transactions    */
double rate_fee( int, long, long);   /* Fees from 1st long date to second     */
double rate_value( int, long, long);
double rate_cost( int, long, long);
double rate_withdrawal( int, long, long);
double rate_distrib( int, long, long);
double rate_exch( int, long);       /* Exchange rate in effect                */
double rate_price(int, long, int);	/* Price including exchange rate      */
double rate_shares(int, long, long, int);
double rate_yield( int, long, long, YIELD *);
void   rate_add_account( int, long, long);

long convertDate (int, long);
char *daytostr ( long, char *);          /* Change (long)date to (char *)date */
long strtoday ( char * );                /* Change (char *)date to (long)date */
char *dbltostr (double, int);            /* Change double to char *.          */

#endif
