/*
 * Copyright (c) 1997, 1998, 2000, 2001, Mark Buser.
 * Copyright (c) 2001, 2001, 2003, Danny Backx.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the names the authors (see above), nor the names of other
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /pack/anoncvs/xinvest/src/pixmapPXi.h,v 1.11 2003/11/19 19:35:11 danny Exp $
 */
#ifndef PIXMAPP_H
#define PIXMAPP_H

/* The pixmaps */
#include "pixmap/quit.xpm"       /* Button box pixmaps*/
#include "pixmap/about.xpm"
#include "pixmap/change.xpm"
#include "pixmap/calculator.xpm"
#include "pixmap/graph.xpm"
#include "pixmap/portfolio.xpm"
#include "pixmap/edit.xpm"

#include "pixmap/save.xpm"       /* file manager buttons */
#include "pixmap/new.xpm"
#include "pixmap/open.xpm"
#include "pixmap/prev.xpm"
#include "pixmap/next.xpm"

#include "pixmap/DtCMday.s.pm"   /* total return report buttons */
#include "pixmap/DtCMwk.s.pm"
#include "pixmap/DtCMmth.s.pm"
#include "pixmap/quarter.xpm"
#include "pixmap/DtCMyr.s.pm"
#include "pixmap/DtCM2yr.s.pm"
#include "pixmap/DtCM3yr.s.pm"
#include "pixmap/DtCM5yr.s.pm"
#include "pixmap/DtCM10yr.s.pm"
#include "pixmap/ytd.xpm"
#include "pixmap/first.xpm"
#include "pixmap/pick.xpm"
#include "pixmap/folder.xpm"

#include "pixmap/check.xpm"      /* portfolio buttons */
#include "pixmap/x.xpm"

#include "pixmap/acct.xpm"       /* graph mode buttons */
#include "pixmap/accts.xpm"

#include "pixmap/bargraph.xpm"   /* graph buttons */
#include "pixmap/linegraph.xpm"

#include "pixmap/last.xpm"       /* calculator buttons */
#include "pixmap/nexttrans.xpm"
#include "pixmap/prevtrans.xpm"

#include "pixmap/info.xpm"       /* The "about" screen */
#include "pixmap/tile.xpm"       /* Drawing stipple pattern */

#include "pixmap/fv.xpm"         /* Function calculator equation pixmaps */
#include "pixmap/sfv.xpm"
#include "pixmap/pp.xpm"
#include "pixmap/pv.xpm"
#include "pixmap/rate.xpm"

#include "pixmap/Xinvest.l.pm"   /* The icon */
#include "pixmap/Xinvest.t.pm"   /* tiny icon */

#ifdef HAVE_LIBDT
#include "pixmap/print.xpm"
#endif

/* This must be initialized in the same order as Pixmaps in pixname.h */
static char **pixname[] = {
             quit_xpm, about_xpm, change_xpm, calculator_xpm, graph_xpm, port_xpm, edit_xpm,
             save_xpm, new_xpm, open_xpm, prev_xpm, next_xpm,
             DtCMday_s_pm, DtCMwk_s_pm, DtCMmth_s_pm, quarter_xpm, DtCMyr_s_pm, ytd_xpm, first_xpm, pick_xpm,
             DtCM2yr_s_pm, DtCM3yr_s_pm, DtCM5yr_s_pm, DtCM10yr_s_pm, 
             check_xpm, x_xpm, 
             acct_xpm, accts_xpm, folder_xpm,
             bargraph_xpm, linegraph_xpm,
             last_xpm, nexttrans_xpm, prevtrans_xpm,
             info_xpm, tile_xpm, fv_xpm, sfv_xpm, pp_xpm, pv_xpm, rate_xpm, Xinvest_l_pm, Xinvest_t_pm,
#ifdef HAVE_LIBDT
	     print_xpm
#endif
            };
#endif
