/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: HelpPackager.java,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: obo $ $Date: 2006/01/16 12:37:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.help;

import java.io.*;
import java.util.zip.*;
import java.util.jar.*;


public class HelpPackager
{
	private JarOutputStream _jarOutputStream;
	
	
	/*
	 *   in fileName: The file to pack in
	 */ 
	
	public HelpPackager( String fileName )
	{
		try
		{
			(new File( fileName )).createNewFile();		
			_jarOutputStream = new JarOutputStream( new FileOutputStream( fileName,false ) );
		}
        catch( FileNotFoundException e )
        {
            System.err.println("Error creating jar file!" );
        }
		catch( IOException e )
		{
			System.err.println( e.getMessage() );
		}
	}
	
	
	public void addEntry( String entryName,byte[] bytesToAdd )
	{
		if( bytesToAdd == null ) return;
			
		try
		{
			CRC32 crc= new CRC32();
			crc.update( bytesToAdd );
			
			JarEntry ze = new JarEntry( entryName );
			ze.setCrc( crc.getValue() );
			ze.setSize( bytesToAdd.length );
			ze.setMethod( JarEntry.DEFLATED );
			
			_jarOutputStream.putNextEntry( ze );
			if (bytesToAdd.length > 0)
				_jarOutputStream.write( bytesToAdd );
			_jarOutputStream.closeEntry();
		}
		catch( IOException e )
		{
			System.err.println( e.getMessage() );
		}
	}	
	
	
	public void close()
	{
		try
		{
			_jarOutputStream.close();
		}
		catch( IOException e )
		{
			System.err.println( e.getMessage() );
		}
	}

}
