/***************************************************************************
                          theme.c  -  description
                             -------------------
    begin                : Tue Jan 30 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <SDL.h>

#ifdef WITH_SOUND
#include <SDL_mixer.h>
#include "audio.h"
#endif

#include <stdlib.h>
#include <stdio.h>

#include "sdl.h"
#include "dynlist.h"
#include "theme.h"
#include "tools.h"

/* delete theme surface ( for compatiblity with dyn_list) */
inline void delete_theme_surf( void *poi )
{
    if ( poi )
        SDL_FreeSurface( (SDL_Surface*)poi );
}


/* delete theme font */
inline void delete_theme_font( void *poi )
{
    if ( poi )
        free_font( (Font*)poi );
}

/* load a theme */
Theme* load_theme( char *file_name )
{
    Theme *theme = 0;
    char path[512];

    /* get memory */
    theme = malloc( sizeof ( Theme ) );
    memset( theme, 0, sizeof ( Theme ) );

    /* initiate lists */
    dl_init( &theme->surf_list, AUTO_DELETE, delete_theme_surf );
    dl_init( &theme->font_list, AUTO_DELETE, delete_theme_font );

    /* title */
    sprintf( path, "themes/%s/title.bmp", file_name );
    theme->title_pic = load_surf( path, SDL_SWSURFACE );
    dl_add( &theme->surf_list, theme->title_pic );

    /* parents */
    sprintf( path, "themes/%s/lower_bar.bmp", file_name );
    theme->lower_bar_back = load_surf( path, SDL_SWSURFACE );
    sprintf( path, "themes/%s/upper_bar.bmp", file_name );
    theme->upper_bar_back = load_surf( path, SDL_SWSURFACE );
    sprintf( path, "themes/%s/parent_back.bmp", file_name );
    theme->parent_back = load_surf( path, SDL_SWSURFACE );
    sprintf( path, "themes/%s/edit_back.bmp", file_name );
    theme->edit_back = load_surf( path, SDL_SWSURFACE );
    /* list */
    dl_add( &theme->surf_list, theme->lower_bar_back );
    dl_add( &theme->surf_list, theme->upper_bar_back );
    dl_add( &theme->surf_list, theme->parent_back );
    dl_add( &theme->surf_list, theme->edit_back );

    /* buttons */
    /* standard text_button */
    sprintf( path, "themes/%s/text_button.bmp", file_name );
    theme->text_button = load_surf( path, SDL_SWSURFACE );
    /* menu text_button */
    sprintf( path, "themes/%s/menu_text_button.bmp", file_name );
    theme->menu_text_button = load_surf( path, SDL_SWSURFACE );
    /* standard accept_button */
    sprintf( path, "themes/%s/accept_button.bmp", file_name );
    theme->accept_button = load_surf( path, SDL_SWSURFACE );
    /* standard cancel_button */
    sprintf( path, "themes/%s/cancel_button.bmp", file_name );
    theme->cancel_button = load_surf( path, SDL_SWSURFACE );
    /* scrollbar buttons right now simply copied */
    theme->up_button = theme->cancel_button;
    theme->down_button = theme->cancel_button;
    theme->left_button = theme->cancel_button;
    theme->right_button = theme->cancel_button;
    /* menu button */
    sprintf( path, "themes/%s/menu_button.bmp", file_name );
    theme->menu_button = load_surf( path, SDL_SWSURFACE );
    /* end turn button */
    sprintf( path, "themes/%s/end_turn_button.bmp", file_name );
    theme->end_turn_button = load_surf( path, SDL_SWSURFACE );
    /* air mode turn button */
    sprintf( path, "themes/%s/air_mode_button.bmp", file_name );
    theme->air_mode_button = load_surf( path, SDL_SWSURFACE );
    /* undo turn button */
    sprintf( path, "themes/%s/undo_button.bmp", file_name );
    theme->undo_button = load_surf( path, SDL_SWSURFACE );
    /* map button */
    sprintf( path, "themes/%s/map_button.bmp", file_name );
    theme->map_button = load_surf( path, SDL_SWSURFACE );
    /* embark button */
    sprintf( path, "themes/%s/embark_button.bmp", file_name );
    theme->embark_button = load_surf( path, SDL_SWSURFACE );
    /* supply button */
    sprintf( path, "themes/%s/supply_button.bmp", file_name );
    theme->supply_button = load_surf( path, SDL_SWSURFACE );
    /* rename button */
    sprintf( path, "themes/%s/rename_button.bmp", file_name );
    theme->rename_button = load_surf( path, SDL_SWSURFACE );
    /* scenario info button */
    sprintf( path, "themes/%s/scen_info_button.bmp", file_name );
    theme->scen_info_button = load_surf( path, SDL_SWSURFACE );
    /* life bar button */
    sprintf( path, "themes/%s/life_bar_button.bmp", file_name );
    theme->life_bar_button = load_surf( path, SDL_SWSURFACE );
    /* grid button */
    sprintf( path, "themes/%s/grid_button.bmp", file_name );
    theme->grid_button = load_surf( path, SDL_SWSURFACE );
    /* weather button */
    sprintf( path, "themes/%s/weather_button.bmp", file_name );
    theme->weather_button = load_surf( path, SDL_SWSURFACE );
    /* cou turn button */
    sprintf( path, "themes/%s/show_cpu_turn_button.bmp", file_name );
    theme->cpu_button = load_surf( path, SDL_SWSURFACE );
    /* window button */
    sprintf( path, "themes/%s/window_button.bmp", file_name );
    theme->window_button = load_surf( path, SDL_SWSURFACE );
    /* sound button */
    sprintf( path, "themes/%s/sound_button.bmp", file_name );
    theme->sound_button = load_surf( path, SDL_SWSURFACE );
    /* music button */
    sprintf( path, "themes/%s/music_button.bmp", file_name );
    theme->music_button = load_surf( path, SDL_SWSURFACE );
    /* deploy button */
    sprintf( path, "themes/%s/deploy_button.bmp", file_name );
    theme->deploy_button = load_surf( path, SDL_SWSURFACE );
    /* melt button */
    sprintf( path, "themes/%s/melt_button.bmp", file_name );
    theme->melt_button = load_surf( path, SDL_SWSURFACE );
    /* list */
    dl_add( &theme->surf_list, theme->text_button );
    dl_add( &theme->surf_list, theme->menu_text_button );
    dl_add( &theme->surf_list, theme->accept_button );
    dl_add( &theme->surf_list, theme->cancel_button );
    dl_add( &theme->surf_list, theme->menu_button );
    dl_add( &theme->surf_list, theme->end_turn_button );
    dl_add( &theme->surf_list, theme->air_mode_button );
    dl_add( &theme->surf_list, theme->undo_button );
    dl_add( &theme->surf_list, theme->map_button );
    dl_add( &theme->surf_list, theme->embark_button );
    dl_add( &theme->surf_list, theme->supply_button );
    dl_add( &theme->surf_list, theme->rename_button );
    dl_add( &theme->surf_list, theme->scen_info_button );
    dl_add( &theme->surf_list, theme->life_bar_button );
    dl_add( &theme->surf_list, theme->grid_button );
    dl_add( &theme->surf_list, theme->weather_button );
    dl_add( &theme->surf_list, theme->cpu_button );
    dl_add( &theme->surf_list, theme->window_button );
    dl_add( &theme->surf_list, theme->sound_button );
    dl_add( &theme->surf_list, theme->music_button );
    dl_add( &theme->surf_list, theme->deploy_button );
    dl_add( &theme->surf_list, theme->melt_button );

    /* frame */
    sprintf( path, "themes/%s/parent_frame.bmp", file_name );
    theme->parent_frame = load_surf( path, SDL_SWSURFACE );
    dl_add( &theme->surf_list, theme->parent_frame );

    sprintf( path, "themes/%s/list_frame.bmp", file_name );
    theme->list_frame = load_surf( path, SDL_SWSURFACE );
    dl_add( &theme->surf_list, theme->list_frame );

    sprintf( path, "themes/%s/edit_frame.bmp", file_name );
    theme->edit_frame = load_surf( path, SDL_SWSURFACE );
    dl_add( &theme->surf_list, theme->edit_frame );

    /* scrollbar stuff */
    sprintf( path, "themes/%s/up_arrow.bmp", file_name );
    theme->up_arrow = load_surf( path, SDL_SWSURFACE );
    dl_add( &theme->surf_list, theme->up_arrow );
    sprintf( path, "themes/%s/down_arrow.bmp", file_name );
    theme->down_arrow = load_surf( path, SDL_SWSURFACE );
    dl_add( &theme->surf_list, theme->down_arrow );
    sprintf( path, "themes/%s/track_ball.bmp", file_name );
    theme->track_ball = load_surf( path, SDL_SWSURFACE );
    dl_add( &theme->surf_list, theme->track_ball );
    sprintf( path, "themes/%s/hori_ctrl.bmp", file_name );
    theme->hori_ctrl = load_surf( path, SDL_SWSURFACE );
    dl_add( &theme->surf_list, theme->hori_ctrl );
    sprintf( path, "themes/%s/hori_ctrl_button.bmp", file_name );
    theme->hori_ctrl_button = load_surf( path, SDL_SWSURFACE );
    dl_add( &theme->surf_list, theme->hori_ctrl_button );

    /* fonts */
    /* standard font */
    sprintf( path, "themes/%s/stan_font.bmp", file_name );
    theme->stan_font = load_fixed_font( path, 32, 96, 8 );
    /* status bar font */
    sprintf( path, "themes/%s/status_font.bmp", file_name );
    theme->status_font = load_fixed_font( path, 32, 96, 8 );
    /* list */
    dl_add( &theme->font_list, theme->stan_font );
    dl_add( &theme->font_list, theme->status_font );

    /* status icons */
    /* window turn button */
    sprintf( path, "themes/%s/status_icons.bmp", file_name );
    theme->status_icons = load_surf( path, SDL_SWSURFACE );
    /* list */
    dl_add( &theme->surf_list, theme->status_icons );
    /* size */
    theme->status_icon_width = theme->status_icon_height = theme->status_icons->h;

#ifdef WITH_SOUND
    /* sounds */
    sprintf( path, "themes/%s/click.wav", file_name );
    theme->click_sound = sound_chunk_load( path );
    sprintf( path, "themes/%s/edit.wav", file_name );
    theme->edit_sound = sound_chunk_load( path );
#endif

    return theme;
}

/* delete theme */
void delete_theme( Theme *theme )
{
    if ( !theme ) return;

    dl_clear( &theme->surf_list );
    dl_clear( &theme->font_list );

#ifdef WITH_SOUND
    /* sounds */
    sound_chunk_free( theme->click_sound );
    sound_chunk_free( theme->edit_sound );
#endif

    FREE( theme ); theme = 0;
}

