/***************************************************************************
                          engine_tools.h  -  description
                             -------------------
    begin                : Fri Mar 9 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __ENGINE_TOOLS_H
#define __ENGINE_TOOLS_H

/*
====================================================================
This file contains tool functions for the engine and the engine
struct itself.
====================================================================
*/

/* engine cont_status types can be found in player.h */

/* engine status */
enum {
    INIT = 0,
    BRIEFING,
    WAITING,
    MOVING,
    ATTACKING,
    SHOWING_ATT_CROSS,
    SHOWING_DEF_CROSS,
    TAKING_DAMAGE,
    SCROLLING_BY_MOUSE,
    SCROLLING_BY_KEY,
    THINKING, /* when CPU starts to think */
    SHOWING_STRAT_MAP,
    SHOWING_MERGE_UNITS,
    DEPLOYING_UNITS
};

/* engine action */
enum {
    NONE = 0,
    START_MOVE,
    SHOW_ATT_CROSS,
    SHOW_DEF_CROSS,
    BATTLE,
    END_BATTLE,
    SELECT,
    UNSELECT,
    EMBARK,
    DEBARK,
    END_TURN,
    SWITCH_AIR_GROUND,
    GOTO_POS,
    UPDATE_FULL_MAP,
    UNDO_UNIT_MOVE,
    SHOW_STRAT_MAP,
    UPDATE_STRAT_MAP,
    END_STRAT_MAP,
    APPLY_VIDEO_MODE,
    SHOW_MERGE_UNITS,
    END_MERGE_UNITS,
    START_DEPLOY_UNITS,
    END_DEPLOY_UNITS
};

/* types for get_unit */
enum {
    MAP_POS,
    MOUSE_POS,
    GROUND_UNIT,
    AIR_UNIT
};

/* clip types for update_full_map */
enum {
    NO_CLIP = 0,
    CLIP
};

/* fog status */
enum {
    NO_FOG = 0, /* no fog at all */
    OWN_FOG, /* fog changes when unit moves or is selected ( move_mask ) */
    FOREIGN_FOG /* fog is set at beginning of turn and does not change while turn */
};

/* goto map pos option */
enum {
    NO_SCREEN_COPY = 0,
    SCREEN_COPY,
    VERT_SCREEN_COPY,
    HORI_SCREEN_COPY
};

/* max briefing length */
enum {
    MAX_BRIEF_LENGTH = 1024
};

/* scrolling directions */
enum {
    SCROLL_UP = 1,
    SCROLL_RIGHT,
    SCROLL_DOWN,
    SCROLL_LEFT
};

/* vector */
typedef struct {
    float x, y;
} Vector;

/* for embark_unit; if FORCED ground_tran will be abandoned without confirmation */
enum {
    NOT_FORCED = 0,
    FORCED
};

enum {
    AI_ACTIONS_LIMIT = 10
};

/* save slot has it's slot name and the file name
to which the game will be saved if this slot was chosen */
enum { SLOT_COUNT = 10 }; /* always ten slots */
typedef struct {
    char name[128];
    char slot_name[512]; /* slotname is the full name with all extension to _name_ like index */
    char file_name[512];
    int valid; /* can you load from this slot? */
} Save_Slot;

/*
====================================================================
Backup of unit properties that change when moving.
====================================================================
*/
typedef struct {
    /* shallow copy of unit */
    int unit_saved;
    Unit unit;
    /* used to reset map flag if unit captured one */
    int flag_saved; /* these to values used? */
    int dest_nation_id;
    int dest_player_id;
} Unit_Backup;

typedef struct {
    Theme *theme; /* just a pointer */
    int fog_status; /* how to handle fog ? */
    int fog_alpha; /* alpha value when transparent */
    int leave_scen; /* leave the current scenario ? */
    int status; /* status */
    int old_status; /* used to restore status  ater scrolling */
    int cont_status; /* control status; either HUMAN or CPU */
    int action; /* action taken in current programme cycle */
    int window_id; /* if != 0 this window will be run in the end of programme cycle */
    int air_mode; /* switched to air mode ? */
    /* save stuff */
    Save_Slot slots[SLOT_COUNT]; /* save slots */
    int scen_loaded; /* scenario was loaded by load_game; data has been changed and
    engine needs an update so reinit_engine() must be run */
    int restart_scen;
    int final_view; /* scneario is ove and player tooks a final view on the map */
    /* map stuff */
    int x_offset, y_offset; /* offset which needs to be added to current position to draw next tile */
    int start_x, start_y; /* position in screen where to start with drawing of tiles */
    int map_x, map_y; /* current position in map (left upper corner ) */
    int map_width, map_height; /* how many tiles need to be drawn horizontal and vertical */
    int *tile_mask; /* tile mask, used to get map pos from pointer pos */
    /* screen copy stuff for quicker full update */
    int screen_copy_type; /* none, vertical, horizontal */
    int screen_copy_diff; /* how many map tiles need to be redrawn >0 down <0 up */
    SDL_Surface *screen_buffer;
    int redraw_map; /* run update_full_map */
    /* current player */
    int player_id;
    Player *player;
    /* windows -- created by engine */
    Window *lower_bar; /* lower status bar */
    Window *upper_bar; /* upper one */
    Window *conf_window; /* confirm window */
    Window *brief_window; /* briefing window */
    Window *edit_window; /* edit window */
    Window *menu; /* menu with buttons to submenus */
    Window *save_menu; /* just one window used to save/load; */
    Window *options; /* option window */
    Window *scen_info_window; /* scenario info */
    Window *mode_window; /* video mode window */
    Window *deploy_window; /* deploy units window */
    /* cursors */
    SDL_Cursor *stan_cursor;
    SDL_Cursor *up_cursor;
    SDL_Cursor *down_cursor;
    SDL_Cursor *left_cursor;
    SDL_Cursor *right_cursor;
    SDL_Cursor *sel_cursor;
    SDL_Cursor *move_cursor;
    SDL_Cursor *attack_cursor;
    SDL_Cursor *ground_tran_cursor;
    SDL_Cursor *debark_cursor;
    SDL_Cursor *embark_cursor;
    SDL_Cursor *merge_cursor;
    SDL_Cursor *deploy_cursor;
    SDL_Cursor *undeploy_cursor;
    /* stuff needed either by action of status */
    int scroll_dir;
    int last_motion_x, last_motion_y;
    Unit *sel_unit; /* pointer to selected unit */
    Unit *sel_info_unit; /* selected unit for info */
    Unit *sel_target; /* target of unit */
    Damage_Pred *pred; /* damage predicitions for selected unit */
    Damage_Pred *sel_pred; /* predicition belonging to selected unit and target */
    int pred_count;
    int ambush; /* has selected unit been ambushed? */
    int combat_type; /* set by init_next_fight and passed to combat() */
    Way_Point *way; /* way points for moving unit */
    int way_length; /* way length */
    int way_pos; /* currently moving from id way_pos to id way_pos + 1 */
    Unit *ambush_unit; /* if at the end of movement an ambush occurs this pointer will be set and this
    unit will ambush the selected unit */
    float unit_vel; /* unit's movement velocity -- pixels per millisecond */
    Vector move_vector; /* normed moving vector indicating direction */
    Vector start_pos, end_pos; /* start and end position for movement from one tile to another */
    SDL_Surface *back_buffer; /* used to buffer map background */
    /* explosion stuff */
    int expl_frame_width;
    int expl_frame_height;
    int expl_frame_count;
    int expl_frame_offset; /* current frame */
    SDL_Surface *expl_buffer, *expl_buffer2; /* background buffers */
    Way_Point expl_pos, expl_pos2; /* screen positions */
    /* timer stuff */
    Delay scroll_delay;
    Delay move_time;
    Delay cross_delay; /* crosshair's delay */
    Delay expl_delay; /* delay between explosion frames */
    /* cpu action stuff */
    AI_Action cpu_actions[AI_ACTIONS_LIMIT]; /* queued cpu actions */
    int cpu_actions_count;
    /* redraw unit buttons */
    int check_unit_buttons;
    /* is undo move ok? */
    int undo_ok;
    /* backup of unit properties for undo turn */
    Unit_Backup backup;
    /* if for some reason you want to block the whole engine after screen update set this value != 0 */
    int block_time;
    /* partners for mergeing with a specific unit */
    int merge_unit_count;
    Unit* merge_units[6]; /* 6 units at max as we use hextiles */
    /* deploy window stuff */
    Unit **deploy_units;
    int deploy_unit_count;
    int deploy_unit_offset; /* offset in list */
    int deploy_icon_count; /* how many units shown on screen */
    int deploy_sel_id; /* id of currently selected unit; -1 if no selection */
} Engine;

/* same like set_spot_mask but remember not to change this mask when FOREIGN_FOG is set */
void set_fog( Engine *engine, int player_id );

/* if engine::fog_status is OWN_FOG set_spot_mask and update_spot_mask will update
the fog, too else leave it untouched */
/* spot mask indicating which tiles the current player sees */
void set_spot_mask( Engine *engine );
/* update spotting mask with sight of one unit */
int update_spot_mask( Engine *engine, Unit *unit );
/*
====================================================================
Backup spot mask to mask::backup. Used to restore sight when
undo unit move.
====================================================================
*/
void backup_spot_mask( Engine *engine );
/*
====================================================================
Restore backuped spot mask.
====================================================================
*/
void restore_spot_mask( Engine *engine );

/* set move mask from unit and map; checks if unit can embark */
void set_move_mask( Engine *engine, Unit *unit );

/* add a units influence to the infl mask */
void add_infl( Unit *unit );
/* remove a units influence (used when an enemy flees) */
void remove_infl( Unit *unit );
/* remove a units influence (used when an enemy flees) */
void remove_vis_infl( Unit *unit );
/* set influence mask; meaning's explained in map.h */
void set_infl_mask( Engine *engine );
/* set visible influence mask; meaning's explained in map.h */
void set_vis_infl_mask( Engine *engine );

/* check if unit is a valid target for selected unit */
int is_target( Unit *att, Unit *target );
/* check surrounding of passed unit for targets and set up a list of damage predictions */
Damage_Pred* get_pred( Unit *att, int *count );

/* select unit, get possible targets, and save moving range */
int select_unit( Engine *engine, Unit *unit );

/* check if unit can embark at wanted position to wanted type */
int unit_can_embark( Engine *engine, Unit *unit, int x, int y, int type );
/* check if unit can debark at wanted position to wanted type */
int unit_can_debark( Engine *engine, Unit *unit, int x, int y, int type );
/* embark unit to sea/air (specified by type) at coords x,y */
void embark_unit( Engine *engine, Unit *unit, int x, int y, int type );
/* debark unit to sea/air (specified by type) at coords x,y */
void debark_unit( Engine *engine, Unit *unit, int x, int y, int type );

/* check if units are enemies */
int is_enemy( Unit *unit, Unit *target_unit );

/*
====================================================================
Backup data that will be restored when unit move was undone.
====================================================================
*/
void backup_unit( Unit *unit, Unit_Backup *backup );
void restore_unit( Unit *unit, Unit_Backup *backup );
void clear_backup( Unit_Backup *backup );
/*
====================================================================
Clear backup and undo_ok flag.
====================================================================
*/
void deny_undo( Engine *engine );

/*
====================================================================
If there is a unit on this tile mergeing is allowed with return
the pointer.
====================================================================
*/
Unit* get_merge_unit( Unit *unit, int x, int y );
/*
====================================================================
Checks surrounding of unit for other units this unit may merge with.
Sets the static array engine::merge_units as there may be
6 other units at maximum. Includes the setting of mask::merge
====================================================================
*/
void check_merge_units( Engine *engine, Unit *unit );

#endif
