/***************************************************************************
                          deploy.h  -  description
                             -------------------
    begin                : Thu Aug 2 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __DEPLOY_H
#define __DELPOY_H

/*
====================================================================
Contains tools for deploying functions.
====================================================================
*/

/*
====================================================================
Sort and reset position (to x = -1) reinforcements of player.
====================================================================
*/
void reset_avail_reinf( Player *player );

/*
====================================================================
Setup deploy mask for unit (if it's flying: use airfields else
all flags)
====================================================================
*/
void set_deploy_mask( Unit *unit );

/*
====================================================================
Cancel deploy of units of current player.
Remove placed reinforcements from map and reset player's
reinforcement list.
====================================================================
*/
void cancel_deploy( Engine *engine );

/*
====================================================================
Apply deployed units by transfering from player::avail_reinf to
scen::units (note: these units must be already inserted to map).
Sets delay (which is >0 ) to 0.
====================================================================
*/
void apply_deploy( Engine *engine );

/*
====================================================================
Transfer unit pointer from source to target list.
====================================================================
*/
void transfer_unit( Unit *unit, Dyn_List *source, Dyn_List *dest );

/*
====================================================================
Check if a particular unit may be deployed to position x,y
====================================================================
*/
int may_deploy_unit( Unit *unit, int x, int y );

/*
====================================================================
Deploy unit: set position of unit and insert to map. Then transfer
from player::avail_reinf to scen::units
====================================================================
*/
void deploy_unit( Unit *unit, int x, int y );

/*
====================================================================
Get next deployable unit from list engine::deploy_units.
====================================================================
*/
Unit* get_next_deploy_unit( Engine *engine );

/*
====================================================================
Create the list containing all pointers from player::avail_reinf
whose pos is x != -1
====================================================================
*/
void create_deploy_list( Engine *engine );

#endif
