/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * IBM Corporation - initial API and implementation
 * yyyymmdd bug      Email and other contact information
 * -------- -------- -----------------------------------------------------------
 * 20070119   161112 makandre@ca.ibm.com - Andrew Mak, WSE: can't find business thru a proxy server that needs basic auth
 *******************************************************************************/

package org.eclipse.wst.internet.internal.proxy;

import java.net.Authenticator;
import java.util.Properties;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
* This is the plugin class for the org.eclipse.wst.internet.internal.proxy plugin.
* This plugin contains the "Internet" preferences page.
*/
public class InternetPlugin extends AbstractUIPlugin implements IStartup
{
	/**
	 * The identifier of the descriptor of this plugin in plugin.xml.
	 */
	public static final String ID = "org.eclipse.wst.internet.proxy";

	/**
	 * The instance of this plugin.
	 */
	private static InternetPlugin instance;

	/**
	 * Constructor for use by the Eclipse platform only.
	 */
	public InternetPlugin()
	{
		super();
		instance = this;
	}

	/**
	 * Returns the instance of this plugin.
	 */
	static public InternetPlugin getInstance ()
	{
		return instance;
	}

	public void start(BundleContext context) throws Exception
	{
		super.start(context);
		updateProxyProperties();
	}
  
	public void earlyStartup()
	{
		updateProxyProperties();
	}

	/**
	 * Sets the proxy properties to the values in the preferences store.
	 **/
	public void updateProxyProperties ()
	{
		// Set the JVM system proxy properties depending on the values in the system store.
		IPreferenceStore store = getPreferenceStore();
		boolean setProxy = store.getBoolean( PREFERENCE_PROXYCHECKED  );
		boolean useSOCKS = store.getBoolean( PREFERENCE_SOCKSCHECKED );
		boolean setName = store.getBoolean( PREFERENCE_NAMECHECKED  );
		Properties sysProps = System.getProperties();      
		Log.write( this, "updateProxyProperties", Log.INFO, "proxySet: " + setProxy );

		ProxyAuthenticator authenticator = new ProxyAuthenticator();
		Authenticator.setDefault(authenticator);

		if (setProxy)
		{
			String hostname      = store.getString( PREFERENCE_HOSTNAME );
			String port          = store.getString( PREFERENCE_PORT );
			String nonProxyHosts = store.getString( PREFERENCE_NON_PROXY_HOSTS );

			sysProps.put( "proxySet", "true" );

			if (useSOCKS)
			{
				sysProps.put( "socksProxyHost", hostname );
				sysProps.put( "socksProxyPort", port );

				sysProps.remove( "proxyHost" );
				sysProps.remove( "proxyPort" );

				sysProps.remove( "http.proxySet" );
				sysProps.remove( "http.proxyHost" );
				sysProps.remove( "http.proxyPort" );
				sysProps.remove( "http.nonProxyHosts" );

				sysProps.remove( "https.proxySet" );
				sysProps.remove( "https.proxyHost" );
				sysProps.remove( "https.proxyPort" );
				sysProps.remove( "https.nonProxyHosts" );
			}
			else
			{
				sysProps.remove( "socksProxyHost" );
				sysProps.remove( "socksProxyPort" );

				sysProps.put( "proxyHost", hostname ); 
				sysProps.put( "proxyPort", port );

				sysProps.put( "http.proxySet", "true" );
				sysProps.put( "http.proxyHost", hostname );
				sysProps.put( "http.proxyPort", port );
				sysProps.put( "http.nonProxyHosts", nonProxyHosts );

				sysProps.put( "https.proxySet", "true" );
				sysProps.put( "https.proxyHost", hostname );
				sysProps.put( "https.proxyPort", port );
				sysProps.put( "https.nonProxyHosts", nonProxyHosts );
			}
      
			// Authentication is currently supported only for HTTP proxies. The UI will enforce this restriction.
			if(setName)
			{
				String userName = store.getString( PREFERENCE_USERNAME );
				String password = store.getString( PREFERENCE_PASSWORD );

				userName = Encoder.isEncoded(userName) ? Encoder.decode(userName) : userName;
				password = Encoder.isEncoded(password) ? Encoder.decode(password) : password;

				authenticator.addProxyEntry( hostname, userName, password );

				sysProps.put( "http.proxyUser", userName );
				sysProps.put( "http.proxyUserName", userName );
				sysProps.put( "http.proxyPassword", password );

				sysProps.put( "https.proxyUser", userName );
				sysProps.put( "https.proxyUserName", userName );
				sysProps.put( "https.proxyPassword", password );	      	      
			}
			else
			{
				Log.write( this, "updateProxyProperties", Log.INFO, "Removing proxy name properties" );

				sysProps.remove( "http.proxyUser" );
				sysProps.remove( "http.proxyUserName" );
				sysProps.remove( "http.proxyPassword" );	 

				sysProps.remove( "https.proxyUser" );
				sysProps.remove( "https.proxyUserName" );
				sysProps.remove( "https.proxyPassword" );          
			}

			Log.write( this, "updateProxyProperties", Log.INFO, "proxyHost: " + hostname );
			Log.write( this, "updateProxyProperties", Log.INFO, "proxyPort: " + port );
			Log.write( this, "updateProxyProperties", Log.INFO, "http.proxyHost: " + hostname);
			Log.write( this, "updateProxyProperties", Log.INFO, "http.proxyPort: " + port);     
			Log.write( this, "updateProxyProperties", Log.INFO, "http.nonProxyHosts: " + nonProxyHosts );     
		}
		else
		{
			Log.write( this, "updateProxyProperties", Log.INFO, "Removing proxy properties" );

			sysProps.remove( "proxySet" ); 
			sysProps.remove( "proxyHost" ); 
			sysProps.remove( "proxyPort" );

			sysProps.remove( "socksProxyHost" );
			sysProps.remove( "socksProxyPort" );

			sysProps.remove( "http.proxySet" );
			sysProps.remove( "http.proxyHost" );
			sysProps.remove( "http.proxyPort" );
			sysProps.remove( "http.proxyUser" );
			sysProps.remove( "http.proxyUserName" );
			sysProps.remove( "http.proxyPassword" );
			sysProps.remove( "http.nonProxyHosts" );

			sysProps.remove( "https.proxySet" );
			sysProps.remove( "https.proxyHost" );
			sysProps.remove( "https.proxyPort" );
			sysProps.remove( "https.proxyUser" );
			sysProps.remove( "https.proxyUserName" );
			sysProps.remove( "https.proxyPassword" );
			sysProps.remove( "https.nonProxyHosts" );
		}
	}

	/**
	 * This constant string is used to lookup the checkBox internet preference from
	 * the plugins local preferences store.
	 */
	public static final String PREFERENCE_PROXYCHECKED = "proxyCheckBox";

	public static final String PREFERENCE_NAMECHECKED = "nameCheckBox";
  
	public static final String PREFERENCE_SOCKSCHECKED = "socksCheckBox";

	/**
	 * This constant string is used to lookup the hostname internet preference from
	 * the plugins local preferences store.
	 */
	public static final String PREFERENCE_HOSTNAME = "hostnameText";

	/**
	 * This constant string is used to lookup the port internet preference from
	 * the plugins local preferences store.
	 */
	public static final String PREFERENCE_PORT = "portText";

	/**
	 * This constant string is used to lookup the userName internet preference from
	 * the plugins local preferences store.
	 */
	public static final String PREFERENCE_USERNAME = "userNameText";

	/**
	 * This constant string is used to lookup the password internet preference from
	 * the plugins local preferences store.
	 */
	public static final String PREFERENCE_PASSWORD = "passwordText";
  
	/**
	 * This constant string is used to lookup the non proxy hosts internet preference from
	 * the plugins local preferences store.
	 */
	public static final String PREFERENCE_NON_PROXY_HOSTS = "nonProxyHostsText";
}
