/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.data.internal.ui;

import org.eclipse.wst.rdb.data.internal.core.common.Output;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewAPI;

/**
 * @author groux
 */
public class OutputItemAdapter implements Output {

    protected OutputItem outputItem; 
    
    public OutputItemAdapter(OutputItem outputItem)
    {
        this.outputItem = outputItem;
    }
    
    public void write(String s)
    {
        OutputViewAPI.getInstance().showMessage(outputItem, s, true);
    }

}
