/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.ui.internal.util.ComponentReferenceUtil;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.wsdl.ui.internal.visitor.BindingRenamer;
import org.eclipse.wst.wsdl.ui.internal.visitor.MessageRenamer;
import org.eclipse.wst.wsdl.ui.internal.visitor.PortTypeRenamer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RenameAction {
    protected Object modelObject;
    protected String newName;
    protected Node node;

    public RenameAction(Object modelObject, String newName) {
        this.modelObject = modelObject;
        this.newName = newName;
        this.node = WSDLEditorUtil.getInstance().getNodeForObject(modelObject);
    }

    public void run() {
        if (this.modelObject instanceof Operation) {
            this.renameOperationHelper((Operation)this.modelObject);
        } else if (this.modelObject instanceof Input || this.modelObject instanceof Output || this.modelObject instanceof Fault) {
            this.renameIOFHelper((WSDLElement)this.modelObject);
        } else {
            this.renameModelObjectHelper(this.modelObject, this.newName);
        }
    }

    protected void renameModelObjectHelper(Object modelObject, String theNewName) {
        Element element = WSDLEditorUtil.getInstance().getElementForObject(modelObject);
        if (element != null) {
            element.setAttribute("name", theNewName);
        }
        if (modelObject instanceof Message) {
            MessageRenamer renamer = new MessageRenamer((WSDLElement)((Message)modelObject), theNewName);
            renamer.visitBindings();
        } else if (modelObject instanceof PortType) {
            PortTypeRenamer renamer = new PortTypeRenamer((WSDLElement)((PortType)modelObject), theNewName);
            renamer.visitBindings();
        } else if (modelObject instanceof Binding) {
            BindingRenamer renamer = new BindingRenamer((WSDLElement)((Binding)modelObject), theNewName);
            renamer.visitServices();
        }
    }

    protected void renameOperationHelper(Operation operation) {
        this.renameModelObjectHelper(operation, this.newName);
    }

    protected void renameIOFHelper(WSDLElement object) {
        Definition definition = object.getEnclosingDefinition();
        ComponentReferenceUtil util = new ComponentReferenceUtil(definition);
        List list = null;
        list = object instanceof Input ? util.getBindingInputs((Input)object) : (object instanceof Output ? util.getBindingOutputs((Output)object) : util.getBindingFaults((Fault)object));
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Object bindingObject = i.next();
                this.renameModelObjectHelper(bindingObject, this.newName);
            }
        }
        this.renameModelObjectHelper(object, this.newName);
    }
}

