/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;
import org.eclipse.wst.server.ui.internal.wizard.ClosableWizardDialog;
import org.eclipse.wst.server.ui.internal.wizard.ModifyModulesWizard;

public class ModuleSloshAction
extends AbstractServerAction {
    public ModuleSloshAction(Shell shell, ISelectionProvider selectionProvider, String name) {
        super(shell, selectionProvider, name);
    }

    public boolean accept(IServer server) {
        return true;
    }

    public void perform(IServer server) {
        if (server == null) {
            return;
        }
        ArrayList<IModule> deployed = new ArrayList<IModule>();
        ArrayList<IModule> modules = new ArrayList<IModule>();
        IModule[] currentModules = server.getModules();
        if (currentModules != null) {
            int size = currentModules.length;
            int i = 0;
            while (i < size) {
                deployed.add(currentModules[i]);
                ++i;
            }
        }
        IModule[] modules2 = ServerUtil.getModules((IModuleType[])server.getServerType().getRuntimeType().getModuleTypes());
        if (modules != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                IStatus status;
                IModule module = modules2[i];
                if (!deployed.contains(module) && (status = server.canModifyModules(new IModule[]{module}, null, null)) != null && status.getSeverity() != 4) {
                    modules.add(module);
                }
                ++i;
            }
        }
        if (deployed.isEmpty() && modules.isEmpty()) {
            MessageDialog.openInformation((Shell)this.shell, (String)Messages.defaultDialogTitle, (String)Messages.dialogAddRemoveModulesNone);
            return;
        }
        ModifyModulesWizard wizard = new ModifyModulesWizard(server);
        ClosableWizardDialog dialog = new ClosableWizardDialog(this.shell, wizard);
        dialog.open();
    }
}

