/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.reconcile.DirtyRegionProcessor;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredTextReconcilingStrategy;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorBuilder;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorMetaData;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ValidatorStrategy;
import org.eclipse.wst.sse.ui.internal.spelling.SpellcheckStrategy;

public class DocumentRegionProcessor
extends DirtyRegionProcessor {
    private static final boolean DEBUG_VALIDATORS = Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerValidators"));
    private SpellcheckStrategy fSpellcheckStrategy;
    private ValidatorStrategy fValidatorStrategy;
    private final String SSE_UI_ID = "org.eclipse.wst.sse.ui";

    protected void beginProcessing() {
        super.beginProcessing();
        ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
        if (validatorStrategy != null) {
            validatorStrategy.beginProcessing();
        }
    }

    protected void endProcessing() {
        super.endProcessing();
        ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
        if (validatorStrategy != null) {
            validatorStrategy.endProcessing();
        }
    }

    protected String getContentType(IDocument doc) {
        if (doc == null) {
            return null;
        }
        String contentTypeId = null;
        IContentType ct = null;
        try {
            IContentDescription desc = Platform.getContentTypeManager().getDescriptionFor((InputStream)new ByteArrayInputStream(doc.get().getBytes()), null, IContentDescription.ALL);
            if (desc != null && (ct = desc.getContentType()) != null) {
                contentTypeId = ct.getId();
            }
        }
        catch (IOException iOException) {}
        return contentTypeId;
    }

    protected final StructuredTextReconcilingStrategy getSpellcheckStrategy() {
        String contentTypeId;
        if (this.fSpellcheckStrategy == null && (contentTypeId = this.getContentType(this.getDocument())) != null && this.getTextViewer() instanceof ISourceViewer) {
            ISourceViewer viewer = (ISourceViewer)this.getTextViewer();
            this.fSpellcheckStrategy = new SpellcheckStrategy(viewer, contentTypeId);
            this.fSpellcheckStrategy.setDocument(this.getDocument());
            this.fSpellcheckStrategy.setDocumentPartitioning(this.getDocumentPartitioning());
        }
        return this.fSpellcheckStrategy;
    }

    protected ValidatorStrategy getValidatorStrategy() {
        if (this.fValidatorStrategy == null) {
            ValidatorStrategy validatorStrategy = null;
            if (this.getTextViewer() instanceof ISourceViewer) {
                ISourceViewer viewer = (ISourceViewer)this.getTextViewer();
                String contentTypeId = null;
                IDocument doc = viewer.getDocument();
                contentTypeId = this.getContentType(doc);
                if (contentTypeId != null) {
                    validatorStrategy = new ValidatorStrategy(viewer, contentTypeId);
                    ValidatorBuilder vBuilder = new ValidatorBuilder();
                    ValidatorMetaData[] vmds = vBuilder.getValidatorMetaData("org.eclipse.wst.sse.ui");
                    ArrayList<ValidatorMetaData> enabledValidators = new ArrayList<ValidatorMetaData>(1);
                    boolean foundSpecificContentTypeValidators = false;
                    int i = 0;
                    while (i < vmds.length) {
                        if (vmds[i].mustHandleContentType(contentTypeId)) {
                            if (DEBUG_VALIDATORS) {
                                Logger.log(1, String.valueOf(contentTypeId) + " using specific validator " + vmds[i].getValidatorId());
                            }
                            foundSpecificContentTypeValidators = true;
                            enabledValidators.add(vmds[i]);
                        }
                        ++i;
                    }
                    if (!foundSpecificContentTypeValidators) {
                        i = 0;
                        while (i < vmds.length) {
                            if (vmds[i].canHandleContentType(contentTypeId)) {
                                if (DEBUG_VALIDATORS) {
                                    Logger.log(1, String.valueOf(contentTypeId) + " using inherited(?) validator " + vmds[i].getValidatorId());
                                }
                                enabledValidators.add(vmds[i]);
                            }
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < enabledValidators.size()) {
                        validatorStrategy.addValidatorMetaData((ValidatorMetaData)enabledValidators.get(i));
                        ++i;
                    }
                }
            }
            this.fValidatorStrategy = validatorStrategy;
        }
        return this.fValidatorStrategy;
    }

    protected void process(DirtyRegion dirtyRegion) {
        if (!this.isInstalled() || this.isInRewriteSession()) {
            return;
        }
        super.process(dirtyRegion);
        ITypedRegion[] partitions = this.computePartitioning(dirtyRegion);
        DirtyRegion dirty = null;
        int i = 0;
        while (i < partitions.length) {
            if (this.getValidatorStrategy() != null) {
                dirty = this.createDirtyRegion(partitions[i], "__insert");
                this.getValidatorStrategy().reconcile(partitions[i], dirty);
            }
            ++i;
        }
        if (this.getSpellcheckStrategy() != null) {
            this.getSpellcheckStrategy().reconcile(dirtyRegion, (IRegion)dirtyRegion);
        }
    }

    public void setDocument(IDocument doc) {
        super.setDocument(doc);
        ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
        if (validatorStrategy != null) {
            validatorStrategy.setDocument(doc);
        }
        if (this.fSpellcheckStrategy != null) {
            this.fSpellcheckStrategy.setDocument(doc);
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.cancel();
            ValidatorStrategy validatorStrategy = this.getValidatorStrategy();
            if (validatorStrategy != null && validatorStrategy instanceof IReleasable) {
                ((IReleasable)validatorStrategy).release();
            }
            if (this.fSpellcheckStrategy != null) {
                this.fSpellcheckStrategy.setDocument(null);
            }
        }
        super.uninstall();
    }
}

