/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.css.ui.internal.contentassist.CSSCACandidate;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistContext;
import org.eclipse.wst.css.ui.internal.image.CSSImageHelper;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

abstract class CSSProposalGenerator {
    protected CSSContentAssistContext fContext = null;

    private CSSProposalGenerator() {
    }

    CSSProposalGenerator(CSSContentAssistContext context) {
        this.fContext = context;
    }

    protected boolean checkLeadingColon() {
        RegionIterator iterator;
        boolean hasLeadingColon = false;
        ITextRegion targetRegion = this.fContext.getTargetRegion();
        if (targetRegion == null && this.fContext.getCursorPos() > 0) {
            targetRegion = this.fContext.getRegionByOffset(this.fContext.getCursorPos() - 1);
            if (targetRegion != null && targetRegion.getType() == "SELECTOR_PSEUDO") {
                hasLeadingColon = true;
            }
        } else if (targetRegion != null && (iterator = this.fContext.getRegionIterator()).hasPrev()) {
            iterator.prev();
            if (iterator.hasPrev() && iterator.prev().getType() == "SELECTOR_PSEUDO") {
                hasLeadingColon = true;
            }
        }
        return hasLeadingColon;
    }

    protected StringAndOffset generateBraces() {
        StringBuffer buf = new StringBuffer();
        String lineDelimiter = this.fContext.getStructuredDocument().getLineDelimiter();
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        String indentStr = this.getIndentString();
        if (preferences.getBoolean("newLineOnOpenBrace")) {
            buf.append(lineDelimiter);
        }
        buf.append("{");
        if (preferences.getBoolean("onePropertyPerLine")) {
            buf.append(lineDelimiter);
            buf.append(indentStr);
        } else {
            buf.append(" ");
        }
        int offset = buf.length();
        if (preferences.getBoolean("onePropertyPerLine")) {
            buf.append(lineDelimiter);
        } else {
            buf.append(" ");
        }
        buf.append("}");
        return new StringAndOffset(buf.toString(), offset);
    }

    protected StringAndOffset generateParenthesis() {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        int offset = 1;
        buf.append(")");
        return new StringAndOffset(buf.toString(), offset);
    }

    protected StringAndOffset generateQuotes() {
        StringBuffer buf = new StringBuffer();
        char quoteChar = this.getQuoteChar();
        buf.append(quoteChar);
        buf.append(quoteChar);
        return new StringAndOffset(buf.toString(), 1);
    }

    protected StringAndOffset generateSemicolon() {
        StringBuffer buf = new StringBuffer();
        buf.append(";");
        int offset = 0;
        return new StringAndOffset(buf.toString(), offset);
    }

    protected StringAndOffset generateURI() {
        StringBuffer buf = new StringBuffer();
        boolean isQuoteInURI = CSSCorePlugin.getDefault().getPluginPreferences().getBoolean("quoteInURI");
        char quoteChar = this.getQuoteChar();
        buf.append("url(");
        if (isQuoteInURI) {
            buf.append(quoteChar);
        }
        int offset = buf.length();
        if (isQuoteInURI) {
            buf.append(quoteChar);
        }
        buf.append(")");
        return new StringAndOffset(buf.toString(), offset);
    }

    protected abstract Iterator getCandidates();

    List getProposals() {
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        CSSImageHelper imageHelper = CSSImageHelper.getInstance();
        Iterator i = this.getCandidates();
        while (i.hasNext()) {
            CSSCACandidate candidate = (CSSCACandidate)i.next();
            Image image = imageHelper.getImage(candidate.getImageType());
            CompletionProposal item = new CompletionProposal(candidate.getReplacementString(), this.fContext.getReplaceBegin() + this.fContext.getDocumentOffset(), this.fContext.getTextToReplace().length(), candidate.getCursorPosition(), image, candidate.getDisplayString(), null, null);
            proposals.add(item);
        }
        return proposals;
    }

    private char getQuoteChar() {
        String quoteStr = CSSCorePlugin.getDefault().getPluginPreferences().getString("quote");
        int quoteChar = quoteStr != null && quoteStr.length() > 0 ? (int)quoteStr.charAt(0) : 34;
        char attrQuote = this.fContext.getQuoteOfStyleAttribute();
        if (attrQuote != '\u0000') {
            if (attrQuote == '\"' && quoteChar == 34) {
                quoteChar = 39;
            } else if (attrQuote == '\'' && quoteChar == 39) {
                quoteChar = 34;
            }
        }
        return (char)quoteChar;
    }

    protected boolean isMatch(String text) {
        String textToCompare = this.fContext.getTextToCompare();
        if (textToCompare.length() == 0) {
            return true;
        }
        return text.toUpperCase().indexOf(textToCompare.toUpperCase()) == 0;
    }

    private String getIndentString() {
        StringBuffer indent = new StringBuffer();
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        if (preferences != null) {
            char indentChar = ' ';
            String indentCharPref = preferences.getString("indentationChar");
            if ("tab".equals(indentCharPref)) {
                indentChar = '\t';
            }
            int indentationWidth = preferences.getInt("indentationSize");
            int i = 0;
            while (i < indentationWidth) {
                indent.append(indentChar);
                ++i;
            }
        }
        return indent.toString();
    }

    protected class StringAndOffset {
        String fString;
        int fOffset;

        StringAndOffset(String string, int offset) {
            this.fString = string;
            this.fOffset = offset;
        }
    }
}

