/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ext.test;

import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.ws.internal.ext.WebServiceExtension;
import org.eclipse.jst.ws.internal.ext.WebServiceExtensionRegistryImpl;
import org.eclipse.jst.ws.internal.ext.test.WebServiceTestExtension;

public class WebServiceTestRegistry
extends WebServiceExtensionRegistryImpl {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private static WebServiceTestRegistry wstr;

    public static WebServiceTestRegistry getInstance() {
        if (wstr == null) {
            wstr = new WebServiceTestRegistry();
        }
        return wstr;
    }

    private WebServiceTestRegistry() {
    }

    private String genNewValue(String existingValue, String newValue) {
        if (existingValue == null || newValue == null) {
            return newValue;
        }
        return String.valueOf(existingValue) + " " + newValue;
    }

    protected void loadExtensions() {
        Hashtable<String, String> supportedClientRuntimes = new Hashtable<String, String>();
        IConfigurationElement[] config = this.getConfigElements();
        int idx = 0;
        while (idx < config.length) {
            IConfigurationElement elem = config[idx];
            String label = elem.getAttribute("label");
            String id = elem.getAttribute("id");
            if (label != null) {
                WebServiceExtension webServiceExtension = this.createWebServiceExtension(elem);
                this.nameExtensionTable_.put(label, webServiceExtension);
                this.label_.add(label);
                this.id_.add(id);
            } else {
                String existingValue = (String)supportedClientRuntimes.get(id);
                String newValue = this.genNewValue(existingValue, elem.getAttribute("supportedClientRuntimes"));
                if (newValue != null) {
                    supportedClientRuntimes.put(id, newValue);
                }
            }
            ++idx;
        }
        Iterator iter = this.nameExtensionTable_.values().iterator();
        while (iter.hasNext()) {
            WebServiceTestExtension webServiceTestExtension = (WebServiceTestExtension)iter.next();
            if (!webServiceTestExtension.allowClientRuntimesRestriction()) continue;
            String id = webServiceTestExtension.getId();
            webServiceTestExtension.addRuntimes((String)supportedClientRuntimes.get(id));
        }
    }

    public WebServiceExtension createWebServiceExtension(IConfigurationElement configElement) {
        return new WebServiceTestExtension(configElement);
    }

    public IConfigurationElement[] getConfigElements() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] config = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "tester");
        return config;
    }
}

