/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.ui.core.JEMUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    public static void handle(InvocationTargetException e, Shell shell, String title, String message) {
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            ExceptionHandler.handle((CoreException)target, shell, title, message);
        } else {
            JEMUIPlugin.getPlugin().getLogger().log((Throwable)e);
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                ExceptionHandler.displayMessageDialog(e, e.getMessage(), shell, title, message);
            } else {
                ExceptionHandler.displayMessageDialog(e, target.getMessage(), shell, title, message);
            }
        }
    }

    public static void handle(CoreException e, Shell shell, String title, String message) {
        JEMUIPlugin.getPlugin().getLogger().log((Throwable)e);
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            ExceptionHandler.displayMessageDialog(e, e.getMessage(), shell, title, message);
        }
    }

    private static void displayMessageDialog(Throwable t, String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write(BeanInfoUIMessages.ExceptionHandler_errordialog_msg_seelog);
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }
}

