/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ModuleKind;
import org.eclipse.wst.server.core.internal.Trace;

public class ModuleType
implements IModuleType {
    protected String id;
    protected String version;
    private static List moduleTypes;

    public ModuleType(String id, String version) {
        this.id = id;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        ModuleKind mt = ModuleType.findModuleType(this.id);
        if (mt != null) {
            return mt.getName();
        }
        return Messages.moduleTypeUnknown;
    }

    public String getVersion() {
        return this.version;
    }

    public static ModuleKind findModuleType(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (moduleTypes == null) {
            ModuleType.loadModuleTypes();
        }
        Iterator iterator = moduleTypes.iterator();
        while (iterator.hasNext()) {
            ModuleKind moduleType = (ModuleKind)iterator.next();
            if (!id.equals(moduleType.getId())) continue;
            return moduleType;
        }
        return null;
    }

    private static synchronized void loadModuleTypes() {
        if (moduleTypes != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .moduleTypes extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", "moduleTypes");
        int size = cf.length;
        moduleTypes = new ArrayList(size);
        int i = 0;
        while (i < size) {
            try {
                ModuleKind moduleType = new ModuleKind(cf[i]);
                moduleTypes.add(moduleType);
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded moduleType: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load moduleType: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .moduleTypes extension point -<-");
    }

    public String toString() {
        return "ModuleType[" + this.id + ", " + this.version + "]";
    }
}

