-- TuxPaint Stamps Installer.applescript
-- TuxPaint Stamps Installer

--  Created by Martin Fuhrer on 09/11/04.
--  Copyright (c) 2004 TuxPaint Devlopment Team. All rights reserved.

property installMode : 1
property archiveName : "tuxpaint-stamps"

on idle
	(* Add any idle time processing here. *)
end idle

on open names
	(* Add your script to process the names here. *)
	
	-- Remove the following line if you want the application to stay open.
	quit
end open

(* Deal with the click event on buttons *)
on clicked theObject
	if the name of theObject is "btnInstall" then
		if installMode is 1 then
			set pathName to (system attribute "HOME") & "/Library/Application Support/TuxPaint"
			install(pathName)
		else if installMode is 2 then
			set pathName to "/Library/Application Support/TuxPaint"
			install(pathName)
		else if installMode is 3 then
			tell open panel
				set title to "Select the Tux Paint application:"
				set prompt to localized string "Choose"
				set treat packages as directories to false
				set can choose directories to false
				set can choose files to true
				set allows multiple selection to false
			end tell
			set title of window "winInstaller" to "Select the Tux Paint application:"
			display open panel in directory "/Applications" attached to window of theObject
		end if
	else if the name of theObject is "btnQuit" then
		quit
	else if the name of theObject is "radCurrent" then
		set installMode to 1
	else if the name of theObject is "radAll" then
		set installMode to 2
	else if the name of theObject is "radApplication" then
		set installMode to 3
	end if
end clicked

on panel ended theObject with result withResult
	if withResult is 1 then
		set pathNames to (path names of open panel as list)
		set pathName to first item of pathNames
		
		-- check that a valid Tux Paint application was selected
		set binary to pathName & "/Contents/MacOS/TuxPaint"
		set commandOne to "test -f " & quoted form of binary
		
		set binary to pathName & "/Contents/MacOS/Tux Paint"
		set commandTwo to "test -f " & quoted form of binary
		
		set validApp to false
		try
			set myResult to do shell script commandOne
			set validApp to true
		on error errorText number errorNumber
		end try
		
		try
			set myResult to do shell script commandTwo
			set validApp to true
		on error errorText number errorNumber
		end try
		
		if validApp is true then
			set pathName to pathName & "/Contents/Resources"
			install(pathName)
		else
			display dialog "Sorry, the application you selected does not appear to be TuxPaint!" buttons {"OK"} default button 1 with icon 1
		end if
	end if
end panel ended

on will close theObject
	if the name of theObject is equal to "winInstaller" then
		quit
	end if
end will close

on install(pathName)
	set enabled of button "btnInstall" of window "winInstaller" to false
	--display panel window "pnlUpdate"
	
	-- remove any pre-existing stamps directory
	set oldStamps to quoted form of (pathName & "/stamps")
	set command to "rm -r " & oldStamps
	try
		do shell script command
	end try
	
	-- create new stamps directory
	set command to "mkdir -p " & quoted form of pathName
	do shell script command
	
	-- extract stamps archive
	set myPath to path to me as string
	set archivePath to myPath & "Contents:Resources:" & archiveName & ".tar.gz" as string
	set archivePath to POSIX path of archivePath
	
	set command to "tar -zxf " & quoted form of archivePath
	set command to command & " -C " & quoted form of pathName
	do shell script command
	
	--close panel window "pnlUpdate"
	display dialog "TuxPaint stamps have been successfully installed!" buttons {"OK"} default button 1 with icon 1
	
	set title of window "winInstaller" to "TuxPaint Stamps Installer"
	set enabled of button "btnInstall" of window "winInstaller" to true
end install
