/*
 * Library of helper functions
 *
 * Provides simple helper functions needed by the other libraries.
 *
 * (C) 2006, Pascal Schmidt <arena-language@ewetel.net>
 * see file ../doc/LICENSE for license
 */
#ifndef MISC_H
#define MISC_H

/*
 * Position in a source file
 */
extern char *source_file;
extern int source_line;
extern int source_col;

/*
 * Error printing
 */
void fatal(const char *msg, ...);
void nonfatal(const char *msg, ...);
void internal(const char *file, int line);

/*
 * Sanity checking macro
 */
#define sanity(x) do { if (!(x)) internal(__FILE__, __LINE__); } while(0)

/*
 * Memory allocation checking
 */
void *oom(void *ptr);

#endif
