<?php
/**
 * @package php-mobile-webaccess
 * @author Mans Matulewicz
 * @version 0.01
 * 
 *
 */
class table {
	
	var $store;
	var $eid;
	var $parent;
	var $parentname;
	var $name;
	var $unread;
	var $amountitems;
	var $sort;
	
	function table($store, $eid)
	{
		$this->store=$store;
		$this->eid=$eid;
	}
	
	function get_parent()
	{
		global $smarty;
		// get name from the store and use this in the navigation link
		$msgstore_props = mapi_getprops($this->store, array(PR_ENTRYID, PR_DISPLAY_NAME));
		$this->parent= $msgstore_props[PR_ENTRYID];
		$smarty->assign('parent', bin2hex($msgstore_props[PR_ENTRYID]));
		$this->parentname= $msgstore_props[PR_DISPLAY_NAME];
		$smarty->assign('parentname', $msgstore_props[PR_DISPLAY_NAME]);
	}

	function getcontents($start=0)
	{
		global $smarty;
		
		$box = mapi_msgstore_openentry($this->store, hex2bin($this->eid));
		$boxprops = mapi_getprops($box, array(PR_DISPLAY_NAME));
		$smarty->assign("display_name", $boxprops[PR_DISPLAY_NAME]);
		$contents = mapi_folder_getcontentstable($box);

		// sort on subject
		
		mapi_table_sort($contents, $this->sort);
		$rows = mapi_table_queryrows($contents, $this->properties, $start, $this->amountitems);
		$smartyarray = array();	
		foreach ($rows as $row)
		{
			$item = array();
			foreach ($this->properties as $key => $property)
			{
				switch ($property)
				{
					case PR_SENT_REPRESENTING_NAME:
						if ((isset($row[$property])) && ($row[$property]!="")){
						
							if (strlen($row[$property]) > 14) {
								$item[$key]=substr($row[$property], 0, 11)."...";
							}
							else {
								$item[$key]=$row[$property];
							}
						}
						else {
							$item[$key]=NOSENDERMSG;
						}
						break;
					
					case PR_ENTRYID:
						$item[$key]=bin2hex($row[$property]);
						break;
						
					case PR_MESSAGE_SIZE:
						$item[$key]=round($row[$property]/1000);
						break;
					
					case PR_DISPLAY_TO:
						if ((isset($row[$property])) && ($row[$property]!="")){
							if (strlen($row[$property]) > 14) {
								$item[$key]=substr($row[$property], 0, 11)."...";
							}
							else {
								$item[$key]=$row[$property];
							}
						}
						else {
							$item[$key]=NOSENDERMSG;
						}
						break;
						
					case PR_MESSAGE_DELIVERY_TIME:
						if (isset($row[$property])){
							if (date("y-m-d",$row[$property])== date('y-m-d')){
								$item[$key]=date("h:i:s",$row[$property]);
							}
							else {
								$item[$key]=date('d-m-Y',$row[$property]);
							}
						}
						break;
						
					case PR_SUBJECT:
						if ((isset($row[$property])) && ($row[$property]!="")){
							$item[$key]=$row[$property];
						}
						else {
							$item[$key]=NOSUBJECTMSG;
						}
						break;
													
					default:
						$item[$key]=isset($row[$property]) ? $row[$property] : null;
						break;
							
				}		
			}
			if ((!isset($row[PR_MESSAGE_DELIVERY_TIME])) && (isset($row[PR_CLIENT_SUBMIT_TIME]))) {
				$item["message_delivery_time"]=date('d-m-Y',$row[PR_CLIENT_SUBMIT_TIME]);
			}
			array_push($smartyarray, $item);
		}
		$smarty->assign('items', $smartyarray);
		$this->get_parent();
	}
	
}
?>
