<?php
/**
 * @package php-mobile-webaccess
 * @author Mans Matulewicz
 * @version 0.01
 * @copyright 2006
 */

class hierarchy{
	
	/**
	 * Contains the message store
	 *
	 * @var resource MAPI_MessageStore
	 */
	var $store;
	var $folders;
	var $properties;
	
	function hierarchy($store)
	{
		$this->store = $store;
		$this->folders = array();
		$this->properties = array();
		$this->properties["entryid"] =PR_ENTRYID;
		$this->properties["name"]=PR_DISPLAY_NAME;
		$this->properties["unread"]=PR_CONTENT_UNREAD;
		$this->properties["subfolders"] = PR_SUBFOLDERS;
		$this->properties["container_class"] = PR_CONTAINER_CLASS;
		
	}

	function subfolders($entryid)
	{
		$smartyarray = array();
		$subfoldersentry = mapi_msgstore_openentry($this->store, $entryid);
		$table = mapi_folder_gethierarchytable($subfoldersentry);
		mapi_table_sort($table, array(PR_DISPLAY_NAME => TABLE_SORT_ASCEND));
		$rows = mapi_table_queryallrows($table, array(PR_ENTRYID, PR_DISPLAY_NAME, PR_CONTENT_UNREAD, PR_CONTAINER_CLASS, PR_SUBFOLDERS));
		foreach ($rows  as $row) 	
		{
			$item = array();
			foreach ($this->properties as $key => $property)
			{
				if ($property==PR_ENTRYID){
					$item[$key]=bin2hex($row[$property]);
				}
				else {
					$item[$key]=$row[$property];
				}
				
			}
			if ($item["subfolders"]){
				$item["subfolders"] = $this->subfolders(hex2bin($item["entryid"]));
			}
			array_push($smartyarray, $item);
	
		}
		return $smartyarray;
	}
	
	function getcontents()
	{
		global $smarty;
		//de properties van default messagestore
		$msgstore_props = mapi_getprops($this->store, array(PR_ENTRYID, PR_DISPLAY_NAME, PR_IPM_SUBTREE_ENTRYID, PR_IPM_OUTBOX_ENTRYID, PR_IPM_SENTMAIL_ENTRYID, PR_IPM_WASTEBASKET_ENTRYID));
		
		//Open de tree onder de default messagestore
		$folder= mapi_msgstore_openentry($this->store, $msgstore_props[PR_IPM_SUBTREE_ENTRYID]);
		
		//haal de table op
		$table = mapi_folder_gethierarchytable($folder);
		mapi_table_sort($table, array(PR_DISPLAY_NAME => TABLE_SORT_ASCEND));
		
		//mapi_folder_sort($folder, $sort);
		
		//vraag de informatie van alle mappen op
		$rows = mapi_table_queryallrows($table, array(PR_ENTRYID, PR_DISPLAY_NAME, PR_CONTENT_UNREAD, PR_CONTAINER_CLASS, PR_SUBFOLDERS));
		
		//hier wordt elke map in de array getoont
		$smartyarray = array();
		foreach ($rows  as $row) 	
		{
			$item = array();
			foreach ($this->properties as $key => $property)
			{
				if ($property==PR_ENTRYID){
					$item[$key]=bin2hex($row[$property]);
				}
				else {
					if (isset($row[$property])){
						$item[$key]=$row[$property];
					}
					
				}
			}
			if (isset($_GET["entryid"]))
			{
				if ($_GET["entryid"]== $item["entryid"]) 
				{
					$item["subfolders"]  = $this->subfolders(hex2bin($_GET["entryid"]));
				}
			}
			array_push($smartyarray, $item);
		}
		$smarty->assign('folders', $smartyarray);
		
		
	}
	
	
	function getallcontents()
	{
		global $smarty;
		//de properties van default messagestore
		$msgstore_props = mapi_getprops($this->store, array(PR_ENTRYID, PR_DISPLAY_NAME, PR_IPM_SUBTREE_ENTRYID, PR_IPM_OUTBOX_ENTRYID, PR_IPM_SENTMAIL_ENTRYID, PR_IPM_WASTEBASKET_ENTRYID));
			
		//Open de tree onder de default messagestore
		$folder= mapi_msgstore_openentry($this->store, $msgstore_props[PR_IPM_SUBTREE_ENTRYID]);
		
		//haal de table op
		$table = mapi_folder_gethierarchytable($folder);
		mapi_table_sort($table, array(PR_DISPLAY_NAME => TABLE_SORT_ASCEND));
		
		//mapi_folder_sort($folder, $sort);
		
		//vraag de informatie van alle mappen op
		$rows = mapi_table_queryallrows($table, array(PR_ENTRYID, PR_DISPLAY_NAME, PR_CONTENT_UNREAD, PR_CONTAINER_CLASS, PR_SUBFOLDERS));
			
		//hier wordt elke map in de array getoont
		$smartyarray = array();
		foreach ($rows  as $row) 	
		{
			$item = array();
			foreach ($this->properties as $key => $property)
			{
				if ($property==PR_ENTRYID){
					$item[$key]=bin2hex($row[$property]);
				}
				else {
					$item[$key]=$row[$property];
				}
			}
			if (isset($row[PR_SUBFOLDERS]))
			{
					$item["subfolders"]  = $this->subfolders($row[PR_ENTRYID]);
			}
			array_push($smartyarray, $item);
		}
		$smarty->assign('folders', $smartyarray);
		
		
	}

}
?>
