<?php


function dump($variable, $backtrace=false)
{
	$file = fopen("debug.txt", "a+");
	$date = strftime("%d-%b-%Y");
	$time = strftime("%H:%M:%S");
	fwrite($file, ("[" . $date . " " . $time . "] " . var_export($variable, true) . "\r\n"));
	if ($backtrace){
		dump(_debug_backtrace(false));
	}
}

function _debug_backtrace($html=true){
  $output = $html?"<br/>\n":"\n";
  foreach(array_reverse(debug_backtrace()) as $t){
    if ($t['function']!='errorreport' && $t['function']!='backtrace'){
      $output .= $html?'<strong>@</strong> ':'@ ';
      if(isset($t['file'])) {
        $output .= basename($t['file']) . ':' . $t['line'];
      } else {
       $output .= '[PHP inner-code]';
      }
      $output .= ' - ';
      if(isset($t['class'])) $output .= $t['class'] . $t['type'];
      $output .= $t['function'];
      if(isset($t['args']) && sizeof($t['args']) > 0) {
        $output .= '(...)';
      } else {
        $output .= '()';
      }
      $output .= $html?"<br/>\n":"\n";
    }
  }
  return $output;
}


function microtime_float() {
	list($usec, $sec) = explode(" ", microtime());
	return ((float)$usec + (float)$sec);
}
	


$GLOBALS["start"] = microtime_float();
?>