/* Nessus
 * Copyright (C) 1998, 1999, 2000 Renaud Deraison
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include <includes.h>
#include "report.h"
#include "report_utils.h"
#include "error_dialog.h"
#include "globals.h"
#include "xml_output.h"

static char *parse_portname ( char *name, int howto );

static char *parse_portname ( char *name, int howto )
{
	char *a, *b, *c;
	char *buf;

	switch ( howto )
	{
		case GET_SERVICE_NAME:
			/*
			 * convert 'telnet (21/tcp)' to 'telnet'
			 */

			a = estrdup ( name );
			buf = strtok ( a, " " );
			b = emalloc ( strlen ( buf ) + 1 );
			strcpy ( b, buf );
			efree ( &name );
			return b;			
			break;
	
		case GET_PORT_NUMBER:  
		  /*
		   * convert 'telnet (21/tcp)' to '21'
		   */

			a = estrdup ( name );
			if ( ( b = strchr ( a, '(' ) ) != 0 )
				a = b + 1;

			c = strtok ( a, "/" );
			buf = emalloc ( strlen ( c ) + 1 );
			strcpy ( buf, c );
			efree ( &name );

			return buf;			   
			break;
	
		case GET_PROTOCOL:
			
			/*
			 * convert 'telnet (21/tcp)' to 'tcp'
			 */
			
			a = estrdup ( name );
			if ( ( b = strchr ( a, '/' ) ) != 0 )
				a = b + 1;
				
			c = strtok ( a, ")" );
			buf = emalloc ( strlen ( c ) + 1 );
			strcpy ( buf, c );
			efree ( &name );
				
			return buf;						 
			break;
	}
}


int 
arglist_to_xml(hosts, filename)
 struct arglist * hosts;
 char * filename;
{
	FILE *file;
	struct arglist *h;
	char *port;
	struct arglist *ports;
	char *hostname;
	char *desc;
	char *name;
	char *buf;

	if ( !strcmp ( filename, "-" ) )
		file = stdout;
	else
		file = fopen ( filename, "w" );
	
	if ( !file )
	{
		show_error ( "Could not create this file! " );
		perror ( "fopen " );
		return ( -1 );
	}	

	fprintf ( file, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" );
	fprintf ( file, "<!DOCTYPE ScanReport SYSTEM \"nsr.dtd\">\n" );
	fprintf ( file, "<ScanReport>\n" );
	
	/*
	 * Write a (small) summary
	 */
	 
	fprintf ( file, "<Summary>\n" );
	fprintf ( file, "\t<AliveHosts>%d</AliveHosts>\n", arglist_length ( hosts ) ); 
	fprintf ( file, "\t<SecurityHoles>%d</SecurityHoles>\n", number_of_holes ( hosts ) );
	fprintf ( file, "\t<SecurityWarnings>%d</SecurityWarnings>\n", number_of_warnings ( hosts ) );
	fprintf ( file, "\t<SecurityNotes>%d</SecurityNotes>\n", number_of_notes ( hosts ) );
	fprintf ( file, "</Summary>\n" );

	h = hosts;

	fprintf ( file, "\n" );
	fprintf ( file, "<TestedHostSummary>\n" );
	while ( h && h->next )
	{
		int result;
		
		fprintf ( file, "\t<TestedHost>\n" );
		fprintf ( file, "\t\t<Hostname>%s</Hostname>\n", h->name );
		
		result = is_there_any_hole ( h->value );
		switch ( result )
		{
			case HOLE_PRESENT:
				fprintf ( file, "\t\t<Result>Security holes found</Result>\n" );
				break;
				
			case WARNING_PRESENT:
				fprintf ( file, "\t\t<Result>Security warnings found</Result>\n" );
				break;
				
			case NOTE_PRESENT:
				fprintf ( file, "\t\t<Result>Security notes found</Result>\n" );
				break;
				
			default:
				fprintf ( file, "\t\t<Result>no noticeable problem found</Result>\n" );
		}
		fprintf ( file, "\t</TestedHost>\n" );
		h = h->next;
	}
	fprintf ( file, "</TestedHostSummary>\n" );

	fprintf ( file, "<Details>\n" );
	while ( hosts && hosts->next )
	{
	  hostname = hosts->name;
	  fprintf ( file, "\t<Host>\n" );
	  fprintf ( file, "\t\t<Name>%s</Name>\n", hostname );
		
		ports = arg_get_value ( hosts->value, "PORTS" );
		if ( ports )
		{
			struct arglist *open = ports;
			if ( open->next )
			{
				fprintf ( file, "\t\t<OpenPorts>\n" );
				while ( open && open->next )
				{
				  fprintf ( file, "\t\t\t<Port>\n" );

					name = estrdup ( open->name );
					buf = parse_portname ( name, GET_SERVICE_NAME );
					fprintf ( file, "\t\t\t\t<Service>%s</Service>\n", buf );
					efree ( &buf );

					name = estrdup ( open->name );
					buf = parse_portname ( name, GET_PORT_NUMBER );
					fprintf ( file, "\t\t\t\t<Number>%s</Number>\n", buf );			  
					efree ( &buf );

					name = estrdup ( open->name ); 
					buf = parse_portname ( name, GET_PROTOCOL );
					fprintf ( file, "\t\t\t\t<Protocol>%s</Protocol>\n", buf );
					efree ( &buf );

					if ( arg_get_value ( open->value, "REPORT" ) )
						fprintf ( file, "\t\t\t\t<Info>Security hole found</Info>\n" );					
					else if ( arg_get_value ( open->value, "INFO" ) )
						fprintf ( file, "\t\t\t\t<Info>Security warning found</Info>\n" );
					else
						fprintf ( file, "\t\t\t\t<Info>Security notes found</Info>\n" );
						
					fprintf ( file, "\t\t\t</Port>\n" );

					open = open->next;
				}						
			
				fprintf ( file, "\t\t</OpenPorts>\n" );
			}			
		}
	
	  /*
	   * Write the summary of the open ports here
	   */

		fprintf ( file, "\t\t<PortSummary>\n" );
		while ( ports && ports->next )
		{
			struct arglist *report;
	    struct arglist *info;
	    struct arglist *note;
		
	  	port = ports->name;
    
			report = arg_get_value(ports->value, "REPORT");
			if ( report )
			{
				while ( report && report->next )
				{
					if ( strlen ( report->value ) )
	    		{  	
			    	fprintf ( file, "\t\t\t<PortInfo>\n" );
						fprintf ( file, "\t\t\t\t<Found>Vulnerability</Found>\n" );
			
						name = estrdup ( ports->name );	
						buf = parse_portname ( name, GET_SERVICE_NAME );
						fprintf ( file, "\t\t\t\t<ServiceName>%s</ServiceName>\n", buf );
						efree ( &buf );
			
						name = estrdup ( ports->name );	
						buf = parse_portname ( name, GET_PORT_NUMBER );
						fprintf ( file, "\t\t\t\t<PortNumber>%s</PortNumber>\n", buf );
						efree ( &buf );
			
						fprintf ( file, "\t\t\t\t<Description>%s</Description>\n", report->value ); 	 
						fprintf ( file, "\t\t\t</PortInfo>\n" );
					}
					report = report->next;
				}
			}

			info = arg_get_value( ports->value, "INFO" );
			if ( info )
			{
					while ( info && info->next )
					{
						if ( strlen ( info->value ) )
						{
							fprintf ( file, "\t\t\t<PortInfo>\n" );
							fprintf ( file, "\t\t\t\t<Found>Warning</Found>\n" );
	
							name = estrdup ( ports->name );
							buf = parse_portname ( name, GET_SERVICE_NAME );
							fprintf ( file, "\t\t\t\t<ServiceName>%s</ServiceName>\n", buf );
							efree ( &buf );
				
							name = estrdup ( ports->name );	
							buf = parse_portname ( name, GET_PORT_NUMBER );
							fprintf ( file, "\t\t\t\t<PortNumber>%s</PortNumber>\n", buf );
							efree ( &buf );
			
							fprintf ( file, "\t\t\t\t<Description>%s</Description>\n", info->value ); 	 
							fprintf ( file, "\t\t\t</PortInfo>\n" );			
						}
						info = info->next;
					}
			}
		
			note = arg_get_value(ports->value, "NOTE");
			if ( note )
			{
				while ( note && note->next )
				{			
					if ( strlen ( note->value ) )
					{
						fprintf ( file, "\t\t\t<PortInfo>\n" );
						fprintf ( file, "\t\t\t\t<Found>Information</Found>\n" );

						name = estrdup ( ports->name );	
						buf = parse_portname ( name, GET_SERVICE_NAME );
						fprintf ( file, "\t\t\t\t<ServiceName>%s</ServiceName>\n", buf );
						efree ( &buf );
			
						name = estrdup ( ports->name );
						buf = parse_portname ( name, GET_PORT_NUMBER );
						fprintf ( file, "\t\t\t\t<PortNumber>%s</PortNumber>\n", buf );
						efree ( &buf );
			
						fprintf ( file, "\t\t\t\t<Description>%s</Description>\n", note->value ); 	 
						fprintf ( file, "\t\t\t</PortInfo>\n" );					
					}
					note = note->next;
				}
			}			
			ports = ports->next;
		}
	
		fprintf ( file, "\t\t</PortSummary>\n" );
	  fprintf ( file, "\t</Host>\n" );		

		hosts = hosts->next; 
	}

	fprintf ( file, "</Details>\n" );
	fprintf ( file, "</ScanReport>\n" );
	fclose ( file );
	
	return ( 0 );
}

