/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.valve;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TomcatTreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;

public final class ValveUtil {
    private static String[] createStandardValveTypes = new String[]{"java.lang.String"};

    public static String createValve(String parent, String valveType, HttpServletResponse response, HttpServletRequest request, ActionMapping mapping, ApplicationServlet servlet) throws IOException, ServletException {
        MessageResources resources = (MessageResources)servlet.getServletContext().getAttribute("org.apache.struts.action.MESSAGE");
        HttpSession session = request.getSession();
        MBeanServer mBServer = null;
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        try {
            mBServer = servlet.getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        String operation = null;
        Object[] values = null;
        String vObjectName = null;
        try {
            String objectName = ValveUtil.getObjectName(parent, ":type=Valve");
            String parentNodeName = parent;
            ObjectName pname = new ObjectName(parent);
            StringBuffer sb = new StringBuffer(pname.getDomain());
            try {
                if ("Service".equalsIgnoreCase(pname.getKeyProperty("type"))) {
                    sb.append(":type=Engine");
                    parent = sb.toString();
                }
            }
            catch (Exception e) {
                String message = resources.getMessage("error.engineName.bad", (Object)sb.toString());
                servlet.log(message);
                response.sendError(400, message);
                return null;
            }
            String domain = pname.getDomain();
            ObjectName fname = TomcatTreeBuilder.getMBeanFactory();
            values = new String[]{parent};
            operation = "create" + valveType;
            if ("AccessLogValve".equalsIgnoreCase(valveType)) {
                operation = "createAccessLoggerValve";
            }
            vObjectName = (String)mBServer.invoke(fname, operation, values, createStandardValveTypes);
            TreeControl control = (TreeControl)session.getAttribute("treeControlTest");
            if (control != null) {
                TreeControlNode parentNode = control.findNode(parentNodeName);
                if (parentNode != null) {
                    String nodeLabel = "Valve for " + parentNode.getLabel();
                    String encodedName = URLEncoder.encode(vObjectName, "UTF-8");
                    TreeControlNode childNode = new TreeControlNode(vObjectName, "Valve.gif", nodeLabel, "EditValve.do?select=" + encodedName + "&nodeLabel=" + URLEncoder.encode(nodeLabel, "UTF-8") + "&parent=" + URLEncoder.encode(parentNodeName, "UTF-8"), "content", true, domain);
                    parentNode.addChild(childNode);
                } else {
                    servlet.log("Cannot find parent node '" + parentNodeName + "'");
                }
            } else {
                servlet.log("Cannot find TreeControlNode!");
            }
        }
        catch (Exception e) {
            servlet.log(resources.getMessage(locale, "users.error.invoke", operation), e);
            response.sendError(500, resources.getMessage(locale, "users.error.invoke", operation));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return vObjectName;
    }

    public static Pattern[] precalculate(String list) throws IllegalArgumentException {
        int comma;
        if (list == null) {
            return new Pattern[0];
        }
        if ((list = list.trim()).length() < 1) {
            return new Pattern[0];
        }
        list = list + ",";
        ArrayList<Pattern> reList = new ArrayList<Pattern>();
        while (list.length() > 0 && (comma = list.indexOf(44)) >= 0) {
            String pattern = list.substring(0, comma).trim();
            try {
                reList.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Syntax error in request filter pattern");
            }
            list = list.substring(comma + 1);
        }
        Pattern[] reArray = new Pattern[reList.size()];
        return reList.toArray(reArray);
    }

    public static String getObjectName(String parent, String MBeanType) throws Exception {
        ObjectName poname = new ObjectName(parent);
        String domain = poname.getDomain();
        StringBuffer sb = new StringBuffer(domain + MBeanType);
        String type = poname.getKeyProperty("type");
        String j2eeType = poname.getKeyProperty("j2eeType");
        String path = "";
        String host = "";
        String name = poname.getKeyProperty("name");
        if (name != null && name.length() > 0) {
            name = name.substring(2);
            int i = name.indexOf("/");
            host = name.substring(0, i);
            path = name.substring(i);
        }
        if ("WebModule".equalsIgnoreCase(j2eeType)) {
            sb.append(",path=" + path);
            sb.append(",host=" + host);
        }
        if ("Host".equalsIgnoreCase(type)) {
            sb.append(",host=");
            sb.append(poname.getKeyProperty("host"));
        }
        if ("Service".equalsIgnoreCase(type)) {
            // empty if block
        }
        return sb.toString();
    }
}

