/* 

                          Firewall Builder

                 Copyright (C) 2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: iptAdvancedDialog.cpp,v 1.22 2005/04/10 07:16:39 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"

#include "iptAdvancedDialog.h"
#include "SimpleTextEditor.h"

#include "fwbuilder/Firewall.h"
#include "fwbuilder/Management.h"
#include "fwbuilder/Resources.h"

#include <qcheckbox.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qwidgetstack.h>
#include <qregexp.h>
#include <qtextview.h>


using namespace std;
using namespace libfwbuilder;


iptAdvancedDialog::iptAdvancedDialog(QWidget *parent,FWObject *o)
    : iptAdvancedDialog_q(parent)
{
    obj=o;

    FWOptions *fwoptions=(Firewall::cast(obj))->getOptionsObject();
    assert(fwoptions!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    logTCPseq->setChecked( fwoptions->getBool("log_tcp_seq") );
    logTCPopt->setChecked( fwoptions->getBool("log_tcp_opt")    );
    logIPopt->setChecked(  fwoptions->getBool("log_ip_opt")     );
    logNumsyslog->setChecked( fwoptions->getBool("use_numeric_log_levels") );

/*
    logLevel->clear();
    logLevels[""]=0;        logLevel->insertItem("",        0);
    logLevels["alert"]=1;   logLevel->insertItem("alert",   1);
    logLevels["crit"]=2;    logLevel->insertItem("crit",    2);
    logLevels["error"]=3;   logLevel->insertItem("error",   3);
    logLevels["warning"]=4; logLevel->insertItem("warning", 4);
    logLevels["notice"]=5;  logLevel->insertItem("notice",  5);
    logLevels["info"]=6;    logLevel->insertItem("info",    6);
    logLevels["debug"]=7;   logLevel->insertItem("debug",   7);
*/
    string ll=fwoptions->getStr("log_level" );
    if (ll=="alert")   logLevel->setCurrentItem(1);
    if (ll=="crit")    logLevel->setCurrentItem(2);
    if (ll=="error")   logLevel->setCurrentItem(3);
    if (ll=="warning") logLevel->setCurrentItem(4);
    if (ll=="notice")  logLevel->setCurrentItem(5);
    if (ll=="info")    logLevel->setCurrentItem(6);
    if (ll=="debug")   logLevel->setCurrentItem(7);


    useLOG->setChecked(      ! fwoptions->getBool("use_ULOG") );
    useULOG->setChecked(       fwoptions->getBool("use_ULOG") );
    switchLOG_ULOG();

    cprange->setValue(         fwoptions->getInt("ulog_cprange") );
    qthreshold->setValue(      fwoptions->getInt("ulog_qthreshold") );
    nlgroup->setValue(         fwoptions->getInt("ulog_nlgroup") );
    
    logprefix->setText(        fwoptions->getStr("log_prefix").c_str() );

    string llsfx=fwoptions->getStr("limit_suffix");
    if (llsfx=="/day")         logLimitSuffix->setCurrentItem(1);
    if (llsfx=="/hour")        logLimitSuffix->setCurrentItem(2);
    if (llsfx=="/minute")      logLimitSuffix->setCurrentItem(3);
    if (llsfx=="/second")      logLimitSuffix->setCurrentItem(4);

    logLimitVal->setValue(     fwoptions->getInt("limit_value") );
//    logAllDropped->setChecked( fwoptions->getBool("log_all_dropped") );
    logAll->setChecked(        fwoptions->getBool("log_all") );
    

    compiler->setText(         fwoptions->getStr("compiler").c_str() );
    compilerArgs->setText(     fwoptions->getStr("cmdline").c_str()  );
    outputFileName->setText(   fwoptions->getStr("output_file").c_str()  );
    
    assumeFwIsPartOfAny->setChecked( fwoptions->getBool("firewall_is_part_of_any_and_networks") );
    acceptSessions->setChecked(      fwoptions->getBool("accept_new_tcp_with_no_syn") );
    dropInvalid->setChecked(         fwoptions->getBool("drop_invalid") );
    logInvalid->setChecked(          fwoptions->getBool("log_invalid") );
    acceptESTBeforeFirst->setChecked(fwoptions->getBool("accept_established"  ) );
    bridge->setChecked(              fwoptions->getBool("bridging_fw") );
    shadowing->setChecked(           fwoptions->getBool("check_shading") );
    emptyGroups->setChecked(         fwoptions->getBool("ignore_empty_groups") );
    localNAT->setChecked(            fwoptions->getBool("local_nat") );
    clampMSStoMTU->setChecked(       fwoptions->getBool("clamp_mss_to_mtu") );

    QString aor=fwoptions->getStr("action_on_reject").c_str();
    if (aor.find( QRegExp("ICMP [aA]dmin [pP]ro") )!=-1) actionOnReject->setCurrentItem(1);
    if (aor.find( QRegExp("ICMP [hH]ost [pP]") )!=-1)    actionOnReject->setCurrentItem(2);
    if (aor.find( QRegExp("ICMP [hH]ost [uU]") )!=-1)    actionOnReject->setCurrentItem(3);
    if (aor.find( QRegExp("ICMP [nN]et [pP]") )!=-1)     actionOnReject->setCurrentItem(4);
    if (aor.find( QRegExp("ICMP [nN]et [uU]") )!=-1)     actionOnReject->setCurrentItem(5);
    if (aor.find( QRegExp("ICMP [pP]ort [uU]") )!=-1)    actionOnReject->setCurrentItem(6);
    if (aor.find( QRegExp("ICMP [pP]rot [uU]") )!=-1)    actionOnReject->setCurrentItem(7);
    if (aor.find( QRegExp("TCP RST") )!=-1)              actionOnReject->setCurrentItem(8);

    mgmt_ssh->setChecked( fwoptions->getBool("mgmt_ssh") );
    mgmt_addr->setText(   fwoptions->getStr("mgmt_addr").c_str() );

    addVirtualsforNAT->setChecked(   fwoptions->getBool("manage_virtual_addr") );
    configureInterfaces->setChecked( fwoptions->getBool("configure_interfaces") );
    iptDebug->setChecked(            fwoptions->getBool("debug") );
    verifyInterfaces->setChecked(    fwoptions->getBool("verify_interfaces") );
    loadModules->setChecked(         fwoptions->getBool("load_modules") );
    iptablesRestoreActivation->setChecked(   fwoptions->getBool("use_iptables_restore") );

/*********************  data for fwbd and install script **************/
//    FWBDManagement      *fwbdm = mgmt->getFWBDManagement();
    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();

    installScript->setText(     pis->getCommand().c_str() );
    installScriptArgs->setText( pis->getArguments().c_str() );

//    if (obj->getStr("host_OS")=="linksys")

    if (fwbdebug)
        qDebug("%s",Resources::getTargetOptionStr(
                   obj->getStr("host_OS"),"user_can_change_install_dir").c_str());

    if (!Resources::getTargetOptionBool(
            obj->getStr("host_OS"),"user_can_change_install_dir"))
    {
        ipt_fw_dir->setEnabled(false);
        fwoptions->setStr("firewall_dir","");
    }

    ipt_fw_dir->setText( fwoptions->getStr("firewall_dir").c_str() );
    ipt_user->setText( fwoptions->getStr("admUser").c_str() );
    altAddress->setText( fwoptions->getStr("altAddress").c_str() );
    sshArgs->setText( fwoptions->getStr("sshArgs").c_str() );
    activationCmd->setText( fwoptions->getStr("activationCmd").c_str() );


/* page "Prolog/Epilog" */
    prolog_script->setText( fwoptions->getStr("prolog_script").c_str() );

    string prolog_place= fwoptions->getStr("prolog_place");

    if (prolog_place == "top")              prologPlace->setCurrentItem(0);
    if (prolog_place == "after_interfaces") prologPlace->setCurrentItem(1);
    if (prolog_place == "after_flush")      prologPlace->setCurrentItem(2);

    epilog_script->setText( fwoptions->getStr("epilog_script").c_str() );




#ifdef HAVE_LIBSSL

//    int port=fwbdm->getPort();
//    if (port==-1) 
//        port= Resources::global_res->getResourceInt("/FWBuilderResources/FWBD/port");
//    mgmt_fwbd_port->set_value( port );
//
//    fillListOfCertificates();
//
//    const Key *key=fwbdm->getPublicKey();
//    if (key) mgmt_fw_key->set_text( key->getFingerprint() );
//
//    if (pis->isEnabled()) mgmt_use_install_script->set_active(true);
//    else                  mgmt_use_fwbd->set_active(true);

#else
//    mgmt_use_fwbd->set_sensitive(false);
//    mgmt_use_install_script->set_active(true);
//
//    disableFWBDoptions();
#endif

}

void iptAdvancedDialog::switchLOG_ULOG()
{
    if (useLOG->isChecked())  logTargetStack->raiseWidget(0);
    else                      logTargetStack->raiseWidget(1);
}

/*
 * store all data in the object
 */
void iptAdvancedDialog::accept()
{
    FWOptions *fwoptions=(Firewall::cast(obj))->getOptionsObject();
    assert(fwoptions!=NULL);

    Management *mgmt=(Firewall::cast(obj))->getManagementObject();
    assert(mgmt!=NULL);

    fwoptions->setBool("log_tcp_seq",     logTCPseq->isChecked());
    fwoptions->setBool("log_tcp_opt",     logTCPopt->isChecked());
    fwoptions->setBool("log_ip_opt",      logIPopt->isChecked());
    fwoptions->setBool("use_numeric_log_levels", 
                       logNumsyslog->isChecked());

    QString ll=logLevel->currentText();
    if (ll.isNull()||ll.isEmpty()) ll="";
    fwoptions->setStr("log_level",        ll.latin1() );

    fwoptions->setBool("use_ULOG",        useULOG->isChecked());

    fwoptions->setInt("ulog_cprange",     cprange->value() );
    fwoptions->setInt("ulog_qthreshold",  qthreshold->value() );
    fwoptions->setInt("ulog_nlgroup",     nlgroup->value() );

    fwoptions->setStr("log_prefix",       logprefix->text().latin1() );

    ll=logLimitSuffix->currentText();
    if (ll.isNull()||ll.isEmpty()) ll="";
    fwoptions->setStr("limit_suffix",     ll.latin1());

    fwoptions->setInt("limit_value",      logLimitVal->value() );
//    fwoptions->setBool("log_all_dropped", logAllDropped->isChecked() );
    fwoptions->setBool("log_all",         logAll->isChecked() );
        
    fwoptions->setBool("firewall_is_part_of_any_and_networks",
                       assumeFwIsPartOfAny->isChecked() );

    fwoptions->setBool("accept_new_tcp_with_no_syn",
                       acceptSessions->isChecked() );

    fwoptions->setBool("drop_invalid",
                       dropInvalid->isChecked() );

    fwoptions->setBool("log_invalid",
                       logInvalid->isChecked() );

    fwoptions->setBool("accept_established",
                       acceptESTBeforeFirst->isChecked() );

    fwoptions->setBool("bridging_fw",     bridge->isChecked() );
    fwoptions->setBool("check_shading",   shadowing->isChecked() );

    fwoptions->setBool("ignore_empty_groups",
                       emptyGroups->isChecked() );

    fwoptions->setBool("local_nat",        localNAT->isChecked() );
    fwoptions->setBool("clamp_mss_to_mtu", clampMSStoMTU->isChecked() );

    ll=actionOnReject->currentText();
    if (ll.isNull()||ll.isEmpty()) ll="";
    fwoptions->setStr("action_on_reject", ll.latin1() );

    fwoptions->setBool("mgmt_ssh", mgmt_ssh->isChecked() );
    fwoptions->setStr("mgmt_addr", mgmt_addr->text().ascii() );


    fwoptions->setBool("manage_virtual_addr",
                       addVirtualsforNAT->isChecked() );

    fwoptions->setBool("configure_interfaces",
                       configureInterfaces->isChecked());

    fwoptions->setBool("debug",            iptDebug->isChecked() );
    fwoptions->setBool("verify_interfaces",verifyInterfaces->isChecked() );
    fwoptions->setBool("load_modules",     loadModules->isChecked() );
    fwoptions->setBool("use_iptables_restore", iptablesRestoreActivation->isChecked());

    fwoptions->setStr("compiler", compiler->text().latin1() );
    fwoptions->setStr("cmdline", compilerArgs->text().latin1()  );
    fwoptions->setStr("output_file", outputFileName->text().latin1()  );
    

/*********************  data for fwbd and install script **************/
//    FWBDManagement      *fwbdm = mgmt->getFWBDManagement();
    PolicyInstallScript *pis   = mgmt->getPolicyInstallScript();
    
    mgmt->setAddress( (Firewall::cast(obj))->getAddress() );

//    fwbdm->setPort( mgmt_fwbd_port->get_value_as_int() );
//
//    map<string, pair<string, string> > certs= Preferences::global_prefs->getCerificates();
//    map<string, pair<string, string> >::iterator i;
//
//    string cert=mgmt_keys->get_entry()->get_text();
//    int n=0;
//    for(i=certs.begin(); i!=certs.end(); i++,n++) 
//        if ( ! (*i).first.empty() && cert == getCertDescString(n , (*i).second.first ) ) {
//            fwbdm->setIdentityId( (*i).first );
//            break;
//        }
//
    pis->setCommand( installScript->text().latin1() );
    pis->setArguments( installScriptArgs->text().latin1() );

    fwoptions->setStr("firewall_dir",ipt_fw_dir->text().latin1());
    fwoptions->setStr("admUser",ipt_user->text().latin1());
    fwoptions->setStr("altAddress",altAddress->text().latin1());
    fwoptions->setStr("sshArgs",sshArgs->text().latin1());
    fwoptions->setStr("activationCmd",activationCmd->text().latin1());

/* page "Prolog/Epilog" */
    fwoptions->setStr("prolog_script", prolog_script->text().latin1() );

    string prolog_place = "";
    switch (prologPlace->currentItem())
    {
    case 1:  prolog_place = "after_interfaces"; break;
    case 2:  prolog_place = "after_flush";      break;
    default: prolog_place = "top";              break;
    }
    fwoptions->setStr("prolog_place",prolog_place);

    fwoptions->setStr("epilog_script", epilog_script->text().latin1() );

//    pis->setEnabled( mgmt_use_install_script->get_active() );
//    fwbdm->setEnabled( mgmt_use_fwbd->get_active() );

    iptAdvancedDialog_q::accept();
}

void iptAdvancedDialog::reject()
{
    iptAdvancedDialog_q::reject();
}

void iptAdvancedDialog::editProlog()
{
    SimpleTextEditor edt( prolog_script->text(),
                          true, tr( "Script Editor" ) );
    if ( edt.exec() == QDialog::Accepted )
        prolog_script->setText( edt.text() );
}

void iptAdvancedDialog::editEpilog()
{
    SimpleTextEditor edt( epilog_script->text(),
                          true, tr( "Script Editor" ) );
    if ( edt.exec() == QDialog::Accepted )
        epilog_script->setText( edt.text() );
}


